/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AssertionMethods;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DominatorsAnalysis;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.PostDominatorsAnalysis;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefDataflow;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefSet;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysis;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.npe.LocationWhereValueBecomesNull;
import edu.umd.cs.findbugs.ba.npe.NullDerefAndRedundantComparisonCollector;
import edu.umd.cs.findbugs.ba.npe.NullValueUnconditionalDeref;
import edu.umd.cs.findbugs.ba.npe.RedundantBranch;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumberSourceInfo;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.log.Profiler;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullDerefAndRedundantComparisonFinder {
    private static final boolean DEBUG = SystemProperties.getBoolean("fnd.debug");
    private static final boolean PRUNE_GUARANTEED_DEREFERENCES = SystemProperties.getBoolean("fnd.prune", true);
    private static final boolean DEBUG_DEREFS = SystemProperties.getBoolean("fnd.derefs.debug");
    private final ClassContext classContext;
    private final Method method;
    private final NullDerefAndRedundantComparisonCollector collector;
    private final boolean findGuaranteedDerefs;
    private final List<RedundantBranch> redundantBranchList;
    private final BitSet definitelySameBranchSet;
    private final BitSet definitelyDifferentBranchSet;
    private final BitSet undeterminedBranchSet;
    private final BitSet lineMentionedMultipleTimes;
    private IsNullValueDataflow invDataflow;
    private ValueNumberDataflow vnaDataflow;
    private UnconditionalValueDerefDataflow uvdDataflow;
    private final AssertionMethods assertionMethods;
    private static final boolean MY_DEBUG = false;

    public NullDerefAndRedundantComparisonFinder(ClassContext classContext, Method method, NullDerefAndRedundantComparisonCollector collector) {
        this.classContext = classContext;
        this.method = method;
        this.collector = collector;
        this.findGuaranteedDerefs = classContext.getAnalysisContext().getBoolProperty(5);
        this.lineMentionedMultipleTimes = classContext.linesMentionedMultipleTimes(method);
        this.redundantBranchList = new LinkedList<RedundantBranch>();
        this.definitelySameBranchSet = new BitSet();
        this.definitelyDifferentBranchSet = new BitSet();
        this.undeterminedBranchSet = new BitSet();
        this.assertionMethods = classContext.getAssertionMethods();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Profiler profiler = Global.getAnalysisCache().getProfiler();
        profiler.start(this.getClass());
        try {
            this.invDataflow = this.classContext.getIsNullValueDataflow(this.method);
            this.vnaDataflow = this.classContext.getValueNumberDataflow(this.method);
            if (this.findGuaranteedDerefs) {
                if (DEBUG_DEREFS) {
                    System.out.println("Checking for guaranteed derefs in " + this.classContext.getClassDescriptor().getDottedClassName() + "." + this.method.getName() + this.method.getSignature());
                }
                this.uvdDataflow = this.classContext.getUnconditionalValueDerefDataflow(this.method);
            }
            this.examineBasicBlocks();
            if (this.findGuaranteedDerefs) {
                this.examineNullValues();
            }
            this.examineRedundantBranches();
        }
        catch (MissingClassException e) {
            AnalysisContext.reportMissingClass(e.getClassNotFoundException());
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error while checking guaranteed derefs in " + this.classContext.getClassDescriptor().getDottedClassName() + "." + this.method.getName() + this.method.getSignature(), e);
        }
        finally {
            profiler.end(this.getClass());
        }
    }

    private void examineBasicBlocks() throws DataflowAnalysisException, CFGBuilderException {
        Iterator<BasicBlock> bbIter = this.invDataflow.getCFG().blockIterator();
        while (bbIter.hasNext()) {
            BasicBlock basicBlock = bbIter.next();
            if (basicBlock.isNullCheck()) {
                this.analyzeNullCheck(this.invDataflow, basicBlock);
                continue;
            }
            if (basicBlock.isEmpty()) continue;
            InstructionHandle lastHandle = basicBlock.getLastInstruction();
            Instruction last = lastHandle.getInstruction();
            switch (last.getOpcode()) {
                case 165: 
                case 166: {
                    this.analyzeRefComparisonBranch(basicBlock, lastHandle);
                    break;
                }
                case 198: 
                case 199: {
                    this.analyzeIfNullBranch(basicBlock, lastHandle);
                }
            }
        }
    }

    private void examineNullValues() throws CFGBuilderException, DataflowAnalysisException {
        Set<LocationWhereValueBecomesNull> locationWhereValueBecomesNullSet = ((IsNullValueAnalysis)this.invDataflow.getAnalysis()).getLocationWhereValueBecomesNullSet();
        if (DEBUG_DEREFS) {
            System.out.println("----------------------- examineNullValues " + locationWhereValueBecomesNullSet.size());
        }
        HashMap<ValueNumber, SortedSet<Location>> bugStatementLocationMap = new HashMap<ValueNumber, SortedSet<Location>>();
        HashMap<ValueNumber, NullValueUnconditionalDeref> nullValueGuaranteedDerefMap = new HashMap<ValueNumber, NullValueUnconditionalDeref>();
        CFG cfg = this.classContext.getCFG(this.method);
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = i.next();
            if (DEBUG_DEREFS) {
                System.out.println("At location " + location);
            }
            this.checkForUnconditionallyDereferencedNullValues(location, bugStatementLocationMap, nullValueGuaranteedDerefMap, (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(location), (IsNullValueFrame)this.invDataflow.getFactAtLocation(location), (UnconditionalValueDerefSet)this.uvdDataflow.getFactAfterLocation(location), false);
        }
        HashSet npeIfStatementCovered = new HashSet(nullValueGuaranteedDerefMap.keySet());
        HashMap<ValueNumber, SortedSet<Location>> bugEdgeLocationMap = new HashMap<ValueNumber, SortedSet<Location>>();
        Iterator i2 = cfg.edgeIterator();
        while (i2.hasNext()) {
            UnconditionalValueDerefSet uvdFact;
            Edge edge = (Edge)i2.next();
            if (edge.isExceptionEdge() && DEBUG_DEREFS) {
                System.out.println("On exception edge " + edge.formatAsString(false));
            }
            if (DEBUG_DEREFS) {
                System.out.println("On edge " + edge.formatAsString(false));
            }
            BasicBlock source = (BasicBlock)edge.getSource();
            BasicBlock basicBlock = (BasicBlock)edge.getTarget();
            ValueNumberFrame vnaFact = (ValueNumberFrame)this.vnaDataflow.getResultFact(source);
            ValueNumberFrame vnaEdgeFact = (ValueNumberFrame)this.vnaDataflow.getFactOnEdge(edge);
            ValueNumberFrame vnaTargetFact = (ValueNumberFrame)this.vnaDataflow.getStartFact(basicBlock);
            IsNullValueFrame invFact = this.invDataflow.getFactAtMidEdge(edge);
            IsNullValueFrame invSourceFact = (IsNullValueFrame)this.invDataflow.getResultFact(source);
            IsNullValueFrame invTargetFact = (IsNullValueFrame)this.invDataflow.getStartFact(basicBlock);
            UnconditionalValueDerefSet uvdSourceFact = (UnconditionalValueDerefSet)this.uvdDataflow.getStartFact(source);
            UnconditionalValueDerefSet uvdTargetFact = (UnconditionalValueDerefSet)this.uvdDataflow.getResultFact(basicBlock);
            Location location = null;
            if (edge.isExceptionEdge()) {
                BasicBlock b = cfg.getSuccessorWithEdgeType(source, 0);
                if (b != null) {
                    location = new Location(source.getExceptionThrower(), b);
                }
            } else {
                location = Location.getLastLocation(source);
            }
            if ((uvdFact = (UnconditionalValueDerefSet)this.uvdDataflow.getFactOnEdge(edge)).isEmpty() || location == null) continue;
            Instruction in = location.getHandle().getInstruction();
            if (this.assertionMethods.isAssertionInstruction(in, this.classContext.getConstantPoolGen())) {
                if (!DEBUG_DEREFS) continue;
                System.out.println("Skipping because it is an assertion method ");
                continue;
            }
            this.checkForUnconditionallyDereferencedNullValues(location, bugEdgeLocationMap, nullValueGuaranteedDerefMap, vnaFact, invFact, uvdFact, true);
        }
        HashMap<ValueNumber, SortedSet<Location>> bugLocationMap = bugEdgeLocationMap;
        bugLocationMap.putAll(bugStatementLocationMap);
        HashMap<ValueNumber, HashSet<Location>> nullValueAssignmentMap = new HashMap<ValueNumber, HashSet<Location>>();
        for (LocationWhereValueBecomesNull locationWhereValueBecomesNull : locationWhereValueBecomesNullSet) {
            HashSet<Location> locationSet;
            if (DEBUG_DEREFS) {
                System.out.println("OOO " + locationWhereValueBecomesNull);
            }
            if ((locationSet = (HashSet<Location>)nullValueAssignmentMap.get(locationWhereValueBecomesNull.getValueNumber())) == null) {
                locationSet = new HashSet<Location>();
                nullValueAssignmentMap.put(locationWhereValueBecomesNull.getValueNumber(), locationSet);
            }
            locationSet.add(locationWhereValueBecomesNull.getLocation());
            if (!DEBUG_DEREFS) continue;
            System.out.println(locationWhereValueBecomesNull.getValueNumber() + " becomes null at " + locationWhereValueBecomesNull.getLocation());
        }
        for (Map.Entry entry : nullValueGuaranteedDerefMap.entrySet()) {
            ValueNumber valueNumber = (ValueNumber)entry.getKey();
            Set<Location> derefLocationSet = ((NullValueUnconditionalDeref)entry.getValue()).getDerefLocationSet();
            Set<Location> assignedNullLocationSet = (Set<Location>)nullValueAssignmentMap.get(valueNumber);
            if (assignedNullLocationSet == null) {
                if (DEBUG_DEREFS) {
                    String where = this.classContext.getJavaClass().getClassName() + "." + this.method.getName() + ":" + this.method.getSignature();
                    System.out.println("Problem at " + where);
                    System.out.println("Value number " + valueNumber);
                    for (Location loc : derefLocationSet) {
                        System.out.println("Dereference at " + loc);
                    }
                }
                assignedNullLocationSet = Collections.emptySet();
            }
            SortedSet knownNullAndDoomedAt = (SortedSet)bugLocationMap.get(valueNumber);
            BugAnnotation variableAnnotation = null;
            try {
                Location loc;
                Iterator<Location> i$ = derefLocationSet.iterator();
                while (i$.hasNext() && (variableAnnotation = ValueNumberSourceInfo.findAnnotationFromValueNumber(this.method, loc = i$.next(), valueNumber, (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(loc), "VALUE_OF")) == null) {
                }
                if (variableAnnotation == null) {
                    i$ = knownNullAndDoomedAt.iterator();
                    while (i$.hasNext() && (variableAnnotation = ValueNumberSourceInfo.findAnnotationFromValueNumber(this.method, loc = i$.next(), valueNumber, (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(loc), "VALUE_OF")) == null) {
                    }
                }
                if (variableAnnotation == null) {
                    i$ = assignedNullLocationSet.iterator();
                    while (i$.hasNext() && (variableAnnotation = ValueNumberSourceInfo.findAnnotationFromValueNumber(this.method, loc = i$.next(), valueNumber, (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(loc), "VALUE_OF")) == null) {
                    }
                }
            }
            catch (DataflowAnalysisException e2) {
                // empty catch block
            }
            if (variableAnnotation == null) {
                variableAnnotation = new LocalVariableAnnotation("?", -1, derefLocationSet.iterator().next().getHandle().getPosition());
            }
            if (PRUNE_GUARANTEED_DEREFERENCES) {
                PostDominatorsAnalysis postDomAnalysis = this.classContext.getNonExceptionPostDominatorsAnalysis(this.method);
                this.removeStrictlyPostDominatedLocations(derefLocationSet, postDomAnalysis);
                this.removeStrictlyPostDominatedLocations(assignedNullLocationSet, postDomAnalysis);
                DominatorsAnalysis domAnalysis = this.classContext.getNonExceptionDominatorsAnalysis(this.method);
                this.removeStrictlyDominatedLocations(knownNullAndDoomedAt, domAnalysis);
            }
            this.collector.foundGuaranteedNullDeref(assignedNullLocationSet, derefLocationSet, knownNullAndDoomedAt, this.vnaDataflow, valueNumber, variableAnnotation, (NullValueUnconditionalDeref)entry.getValue(), npeIfStatementCovered.contains(valueNumber));
        }
    }

    private void removeStrictlyPostDominatedLocations(Set<Location> locations, PostDominatorsAnalysis postDomAnalysis) {
        BitSet strictlyDominated = new BitSet();
        for (Location loc : locations) {
            BitSet allDominatedBy = postDomAnalysis.getAllDominatedBy(loc.getBasicBlock());
            allDominatedBy.clear(loc.getBasicBlock().getLabel());
            strictlyDominated.or(allDominatedBy);
        }
        LinkedList<Location> locations2 = new LinkedList<Location>(locations);
        Iterator<Location> i = locations.iterator();
        block1: while (i.hasNext()) {
            Location loc = i.next();
            if (strictlyDominated.get(loc.getBasicBlock().getLabel())) {
                i.remove();
                continue;
            }
            for (Location loc2 : locations2) {
                if (!loc.getBasicBlock().equals(loc2.getBasicBlock()) || loc.getHandle().getPosition() <= loc2.getHandle().getPosition()) continue;
                i.remove();
                continue block1;
            }
        }
    }

    private void removeStrictlyDominatedLocations(Set<Location> locations, DominatorsAnalysis domAnalysis) {
        BitSet strictlyDominated = new BitSet();
        for (Location loc : locations) {
            BitSet allDominatedBy = domAnalysis.getAllDominatedBy(loc.getBasicBlock());
            allDominatedBy.clear(loc.getBasicBlock().getLabel());
            strictlyDominated.or(allDominatedBy);
        }
        LinkedList<Location> locations2 = new LinkedList<Location>(locations);
        Iterator<Location> i = locations.iterator();
        block1: while (i.hasNext()) {
            Location loc = i.next();
            if (strictlyDominated.get(loc.getBasicBlock().getLabel())) {
                i.remove();
                continue;
            }
            for (Location loc2 : locations2) {
                if (!loc.getBasicBlock().equals(loc2.getBasicBlock()) || loc.getHandle().getPosition() <= loc2.getHandle().getPosition()) continue;
                i.remove();
                continue block1;
            }
        }
    }

    private void checkForUnconditionallyDereferencedNullValues(Location thisLocation, Map<ValueNumber, SortedSet<Location>> knownNullAndDoomedAt, Map<ValueNumber, NullValueUnconditionalDeref> nullValueGuaranteedDerefMap, ValueNumberFrame vnaFrame, IsNullValueFrame invFrame, UnconditionalValueDerefSet derefSet, boolean isEdge) {
        ValueNumber valueNumber;
        if (DEBUG_DEREFS) {
            System.out.println("vna *** " + vnaFrame);
            System.out.println("inv *** " + invFrame);
            System.out.println("deref * " + derefSet);
        }
        if (!vnaFrame.isValid() || !invFrame.isValid() || vnaFrame.getNumLocals() != invFrame.getNumLocals() || derefSet.isEmpty()) {
            return;
        }
        int slots = vnaFrame.getNumSlots() == invFrame.getNumSlots() ? vnaFrame.getNumSlots() : vnaFrame.getNumLocals();
        for (int j = 0; j < slots; ++j) {
            IsNullValue isNullValue = (IsNullValue)invFrame.getValue(j);
            valueNumber = (ValueNumber)vnaFrame.getValue(j);
            if (!isNullValue.isDefinitelyNull() && (!isNullValue.isNullOnSomePath() || !isNullValue.isReturnValue()) || !derefSet.isUnconditionallyDereferenced(valueNumber)) continue;
            Location where = thisLocation;
            if (!isEdge && isNullValue.isNullOnSomePath() && isNullValue.isReturnValue()) {
                try {
                    where = this.classContext.getCFG(this.method).getPreviousLocation(where);
                }
                catch (CFGBuilderException e) {
                    AnalysisContext.logError("Error looking for previous instruction to " + where + " in " + this.classContext.getFullyQualifiedMethodName(this.method), e);
                }
            }
            this.noteUnconditionallyDereferencedNullValue(where, knownNullAndDoomedAt, nullValueGuaranteedDerefMap, derefSet, isNullValue, valueNumber);
        }
        for (Map.Entry<ValueNumber, IsNullValue> entry : invFrame.getKnownValueMapEntrySet()) {
            valueNumber = entry.getKey();
            IsNullValue isNullValue = entry.getValue();
            if (!isNullValue.isDefinitelyNull() && (!isNullValue.isNullOnSomePath() || !isNullValue.isReturnValue() && !isNullValue.isFieldValue()) || !derefSet.isUnconditionallyDereferenced(valueNumber)) continue;
            this.noteUnconditionallyDereferencedNullValue(thisLocation, knownNullAndDoomedAt, nullValueGuaranteedDerefMap, derefSet, isNullValue, valueNumber);
        }
    }

    private void noteUnconditionallyDereferencedNullValue(Location thisLocation, Map<ValueNumber, SortedSet<Location>> bugLocations, Map<ValueNumber, NullValueUnconditionalDeref> nullValueGuaranteedDerefMap, UnconditionalValueDerefSet derefSet, IsNullValue isNullValue, ValueNumber valueNumber) {
        Set<Location> unconditionalDerefLocationSet;
        if (DEBUG) {
            System.out.println("%%% HIT for value number " + valueNumber + " @ " + thisLocation);
        }
        if ((unconditionalDerefLocationSet = derefSet.getUnconditionalDerefLocationSet(valueNumber)).isEmpty()) {
            AnalysisContext.logError("empty set of unconditionally dereferenced locations at " + thisLocation.getHandle().getPosition() + " in " + this.classContext.getClassDescriptor() + "." + this.method.getName() + this.method.getSignature());
            return;
        }
        NullValueUnconditionalDeref thisNullValueDeref = nullValueGuaranteedDerefMap.get(valueNumber);
        if (thisNullValueDeref == null) {
            thisNullValueDeref = new NullValueUnconditionalDeref();
            nullValueGuaranteedDerefMap.put(valueNumber, thisNullValueDeref);
        }
        thisNullValueDeref.add(isNullValue, unconditionalDerefLocationSet);
        if (thisLocation != null) {
            SortedSet<Location> locationsForThisBug = bugLocations.get(valueNumber);
            if (locationsForThisBug == null) {
                locationsForThisBug = new TreeSet<Location>();
                bugLocations.put(valueNumber, locationsForThisBug);
            }
            locationsForThisBug.add(thisLocation);
        }
    }

    private void examineRedundantBranches() {
        for (RedundantBranch redundantBranch : this.redundantBranchList) {
            int lineNumber;
            if (DEBUG) {
                System.out.println("Redundant branch: " + redundantBranch);
            }
            boolean confused = this.undeterminedBranchSet.get(lineNumber = redundantBranch.lineNumber) || this.definitelySameBranchSet.get(lineNumber) && this.definitelyDifferentBranchSet.get(lineNumber);
            boolean reportIt = true;
            if (this.lineMentionedMultipleTimes.get(lineNumber) && confused) {
                reportIt = false;
            } else if (redundantBranch.location.getBasicBlock().isInJSRSubroutine() && confused) {
                reportIt = false;
            } else {
                int pc = redundantBranch.location.getHandle().getPosition();
                for (CodeException e : this.method.getCode().getExceptionTable()) {
                    if (e.getCatchType() != 0 || e.getStartPC() == e.getHandlerPC() || e.getEndPC() > pc || pc > e.getEndPC() + 5) continue;
                    reportIt = false;
                }
            }
            if (!reportIt) continue;
            this.collector.foundRedundantNullCheck(redundantBranch.location, redundantBranch);
        }
    }

    private void analyzeRefComparisonBranch(BasicBlock basicBlock, InstructionHandle lastHandle) throws DataflowAnalysisException {
        boolean definitelyDifferent;
        Location location = new Location(lastHandle, basicBlock);
        IsNullValueFrame frame = (IsNullValueFrame)this.invDataflow.getFactAtLocation(location);
        if (!frame.isValid()) {
            return;
        }
        if (frame.getStackDepth() < 2) {
            throw new DataflowAnalysisException("Stack underflow at " + lastHandle);
        }
        int lineNumber = NullDerefAndRedundantComparisonFinder.getLineNumber(this.method, lastHandle);
        if (lineNumber < 0) {
            return;
        }
        int numSlots = frame.getNumSlots();
        IsNullValue top = (IsNullValue)frame.getValue(numSlots - 1);
        IsNullValue topNext = (IsNullValue)frame.getValue(numSlots - 2);
        boolean definitelySame = top.isDefinitelyNull() && topNext.isDefinitelyNull();
        boolean bl = definitelyDifferent = top.isDefinitelyNull() && topNext.isDefinitelyNotNull() || top.isDefinitelyNotNull() && topNext.isDefinitelyNull();
        if (definitelySame || definitelyDifferent) {
            if (definitelySame) {
                if (DEBUG) {
                    System.out.println("Line " + lineNumber + " always same");
                }
                this.definitelySameBranchSet.set(lineNumber);
            }
            if (definitelyDifferent) {
                if (DEBUG) {
                    System.out.println("Line " + lineNumber + " always different");
                }
                this.definitelyDifferentBranchSet.set(lineNumber);
            }
            RedundantBranch redundantBranch = new RedundantBranch(location, lineNumber, top, topNext);
            boolean wantSame = lastHandle.getInstruction().getOpcode() == 165;
            int infeasibleEdgeType = wantSame == definitelySame ? 0 : 1;
            Edge infeasibleEdge = this.invDataflow.getCFG().getOutgoingEdgeWithType(basicBlock, infeasibleEdgeType);
            redundantBranch.setInfeasibleEdge(infeasibleEdge);
            if (DEBUG) {
                System.out.println("Adding redundant branch: " + redundantBranch);
            }
            this.redundantBranchList.add(redundantBranch);
        } else {
            if (DEBUG) {
                System.out.println("Line " + lineNumber + " undetermined");
            }
            this.undeterminedBranchSet.set(lineNumber);
        }
    }

    private void analyzeIfNullBranch(BasicBlock basicBlock, InstructionHandle lastHandle) throws DataflowAnalysisException {
        Location location = new Location(lastHandle, basicBlock);
        IsNullValueFrame frame = (IsNullValueFrame)this.invDataflow.getFactAtLocation(location);
        if (!frame.isValid()) {
            return;
        }
        IsNullValue top = (IsNullValue)frame.getTopValue();
        int lineNumber = NullDerefAndRedundantComparisonFinder.getLineNumber(this.method, lastHandle);
        if (lineNumber < 0) {
            return;
        }
        if (!top.isDefinitelyNull() && !top.isDefinitelyNotNull()) {
            if (DEBUG) {
                System.out.println("Line " + lineNumber + " undetermined");
            }
            this.undeterminedBranchSet.set(lineNumber);
            return;
        }
        short opcode = lastHandle.getInstruction().getOpcode();
        boolean definitelySame = top.isDefinitelyNull();
        if (opcode != 198) {
            boolean bl = definitelySame = !definitelySame;
        }
        if (definitelySame) {
            if (DEBUG) {
                System.out.println("Line " + lineNumber + " always same");
            }
            this.definitelySameBranchSet.set(lineNumber);
        } else {
            if (DEBUG) {
                System.out.println("Line " + lineNumber + " always different");
            }
            this.definitelyDifferentBranchSet.set(lineNumber);
        }
        RedundantBranch redundantBranch = new RedundantBranch(location, lineNumber, top);
        boolean wantNull = opcode == 198;
        int infeasibleEdgeType = wantNull == top.isDefinitelyNull() ? 0 : 1;
        Edge infeasibleEdge = this.invDataflow.getCFG().getOutgoingEdgeWithType(basicBlock, infeasibleEdgeType);
        redundantBranch.setInfeasibleEdge(infeasibleEdge);
        if (DEBUG) {
            System.out.println("Adding redundant branch: " + redundantBranch);
        }
        this.redundantBranchList.add(redundantBranch);
    }

    private void analyzeNullCheck(IsNullValueDataflow invDataflow, BasicBlock basicBlock) throws DataflowAnalysisException, CFGBuilderException {
        int line;
        InstructionHandle exceptionThrowerHandle = basicBlock.getExceptionThrower();
        Instruction exceptionThrower = exceptionThrowerHandle.getInstruction();
        IsNullValueFrame frame = (IsNullValueFrame)invDataflow.getStartFact(basicBlock);
        if (!frame.isValid()) {
            return;
        }
        IsNullValue refValue = (IsNullValue)frame.getInstance(exceptionThrower, this.classContext.getConstantPoolGen());
        if (DEBUG) {
            System.out.println("For basic block " + basicBlock + " value is " + refValue);
        }
        if (refValue.isDefinitelyNotNull()) {
            return;
        }
        if (!refValue.isDefinitelyNull()) {
            return;
        }
        ValueNumberFrame vnaFrame = (ValueNumberFrame)this.classContext.getValueNumberDataflow(this.method).getStartFact(basicBlock);
        if (!vnaFrame.isValid()) {
            return;
        }
        ValueNumber valueNumber = (ValueNumber)vnaFrame.getInstance(exceptionThrower, this.classContext.getConstantPoolGen());
        Location location = new Location(exceptionThrowerHandle, basicBlock);
        if (DEBUG) {
            System.out.println("Warning: VN " + valueNumber + " invf: " + frame + " @ " + location);
        }
        boolean isConsistent = true;
        Iterator<BasicBlock> bbIter = invDataflow.getCFG().blockIterator();
        LineNumberTable table = this.method.getLineNumberTable();
        int position = exceptionThrowerHandle.getPosition();
        int n = line = table == null ? 0 : table.getSourceLine(position);
        while (bbIter.hasNext()) {
            IsNullValue rv;
            IsNullValueFrame frame2;
            int ePosition;
            InstructionHandle eth;
            BasicBlock bb = bbIter.next();
            if (!bb.isNullCheck() || (eth = bb.getExceptionThrower()) == exceptionThrowerHandle || eth.getInstruction().getOpcode() != exceptionThrower.getOpcode() || (ePosition = eth.getPosition()) != position && (table == null || line != table.getSourceLine(ePosition)) || !(frame2 = (IsNullValueFrame)invDataflow.getStartFact(bb)).isValid() || (rv = (IsNullValue)frame2.getInstance(eth.getInstruction(), this.classContext.getConstantPoolGen())).equals(refValue)) continue;
            isConsistent = false;
        }
        this.collector.foundNullDeref(location, valueNumber, refValue, vnaFrame, isConsistent);
    }

    @Deprecated
    public static XField findXFieldFromValueNumber(Method method, Location location, ValueNumber valueNumber, ValueNumberFrame vnaFrame) {
        return ValueNumberSourceInfo.findXFieldFromValueNumber(method, location, valueNumber, vnaFrame);
    }

    @Deprecated
    public static FieldAnnotation findFieldAnnotationFromValueNumber(Method method, Location location, ValueNumber valueNumber, ValueNumberFrame vnaFrame) {
        return ValueNumberSourceInfo.findFieldAnnotationFromValueNumber(method, location, valueNumber, vnaFrame);
    }

    @Deprecated
    public static LocalVariableAnnotation findLocalAnnotationFromValueNumber(Method method, Location location, ValueNumber valueNumber, ValueNumberFrame vnaFrame) {
        return ValueNumberSourceInfo.findLocalAnnotationFromValueNumber(method, location, valueNumber, vnaFrame);
    }

    @Deprecated
    public static BugAnnotation findAnnotationFromValueNumber(Method method, Location location, ValueNumber valueNumber, ValueNumberFrame vnaFrame) {
        return ValueNumberSourceInfo.findRequiredAnnotationFromValueNumber(method, location, valueNumber, vnaFrame, null);
    }

    private static int getLineNumber(Method method, InstructionHandle handle) {
        LineNumberTable table = method.getCode().getLineNumberTable();
        if (table == null) {
            return -1;
        }
        return table.getSourceLine(handle.getPosition());
    }

    static {
        if (DEBUG) {
            System.out.println("fnd.debug enabled");
        }
    }
}

