/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationFactory;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabase;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseAction;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseActionType;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionActionCache {
    private static final boolean DEBUG_LOOKUP = SystemProperties.getBoolean("oa.debug.lookup");
    private final ObligationPolicyDatabase database;
    private final Map<InstructionHandle, Collection<ObligationPolicyDatabaseAction>> actionCache;
    private final XMethod xmethod;
    private final TypeDataflow typeDataflow;
    private final ConstantPoolGen cpg;

    public InstructionActionCache(ObligationPolicyDatabase database, XMethod xmethod, ConstantPoolGen cpg, TypeDataflow typeDataflow) {
        this.database = database;
        this.actionCache = new HashMap<InstructionHandle, Collection<ObligationPolicyDatabaseAction>>();
        this.xmethod = xmethod;
        this.cpg = cpg;
        this.typeDataflow = typeDataflow;
    }

    public Collection<ObligationPolicyDatabaseAction> getActions(BasicBlock block, InstructionHandle handle) {
        Collection<ObligationPolicyDatabaseAction> actionList = this.actionCache.get(handle);
        if (actionList == null) {
            Instruction ins = handle.getInstruction();
            actionList = Collections.emptyList();
            if (ins instanceof InvokeInstruction) {
                InvokeInstruction inv = (InvokeInstruction)ins;
                String signature = inv.getSignature(this.cpg);
                String methodName = inv.getName(this.cpg);
                if (DEBUG_LOOKUP) {
                    System.out.println("Looking up actions for call to " + methodName + signature);
                }
                if (signature.indexOf(59) >= -1) {
                    actionList = new LinkedList<ObligationPolicyDatabaseAction>();
                    if (signature.substring(0, signature.indexOf(41)).indexOf("Ljava/io/Closeable;") >= 0) {
                        actionList.add(ObligationPolicyDatabaseAction.CLEAR);
                    } else {
                        ReferenceType receiverType = inv.getReferenceType(this.cpg);
                        boolean isStatic = inv.getOpcode() == 184;
                        this.database.getActions(receiverType, methodName, signature, isStatic, actionList);
                        if (actionList.isEmpty()) {
                            actionList = Collections.emptyList();
                        }
                    }
                    if (DEBUG_LOOKUP && !actionList.isEmpty()) {
                        System.out.println("  At " + handle + ": " + actionList);
                    }
                }
            } else if (ins instanceof PUTFIELD || ins instanceof PUTSTATIC || ins instanceof ARETURN) {
                Location loc = new Location(handle, block);
                try {
                    ObligationFactory factory;
                    Obligation obligation;
                    Type tosType;
                    TypeFrame typeFrame = (TypeFrame)this.typeDataflow.getFactAtLocation(loc);
                    if (typeFrame.isValid() && (tosType = (Type)typeFrame.getTopValue()) instanceof ObjectType && (obligation = (factory = this.database.getFactory()).getObligationByType((ObjectType)tosType)) != null) {
                        if (obligation.getClassName().equals("java.sql.ResultSet")) {
                            ObjectType sType = ObjectTypeFactory.getInstance(Statement.class);
                            Obligation sObligation = factory.getObligationByType(sType);
                            actionList = Arrays.asList(new ObligationPolicyDatabaseAction(ObligationPolicyDatabaseActionType.DEL, obligation), new ObligationPolicyDatabaseAction(ObligationPolicyDatabaseActionType.DEL, sObligation));
                        } else {
                            actionList = Collections.singleton(new ObligationPolicyDatabaseAction(ObligationPolicyDatabaseActionType.DEL, obligation));
                        }
                    }
                }
                catch (Exception e) {
                    AnalysisContext.logError("oops", e);
                }
            }
            this.actionCache.put(handle, actionList);
        }
        return actionList;
    }

    public boolean addsObligation(BasicBlock block, InstructionHandle handle, Obligation obligation) {
        return this.hasAction(block, handle, obligation, ObligationPolicyDatabaseActionType.ADD);
    }

    public boolean deletesObligation(BasicBlock block, InstructionHandle handle, Obligation obligation) {
        return this.hasAction(block, handle, obligation, ObligationPolicyDatabaseActionType.DEL);
    }

    private boolean hasAction(BasicBlock block, InstructionHandle handle, Obligation obligation, ObligationPolicyDatabaseActionType actionType) {
        Collection<ObligationPolicyDatabaseAction> actionList = this.getActions(block, handle);
        for (ObligationPolicyDatabaseAction action : actionList) {
            if (action.getActionType() != actionType || !action.getObligation().equals(obligation)) continue;
            return true;
        }
        return false;
    }
}

