/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import java.util.Iterator;
import org.apache.bcel.classfile.Code;

public class IteratorIdioms
extends BytecodeScanningDetector
implements StatelessDetector {
    private ClassDescriptor iteratorDescriptor = DescriptorFactory.createClassDescriptor(Iterator.class);
    private BugReporter bugReporter;
    boolean sawNoSuchElement;
    boolean sawCall;

    public IteratorIdioms(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
        try {
            if (subtypes2.isSubtype(classContext.getClassDescriptor(), this.iteratorDescriptor)) {
                super.visitClassContext(classContext);
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
    }

    public void visit(Code obj) {
        if (this.getMethodName().equals("next") && this.getMethodSig().equals("()Ljava/lang/Object;")) {
            this.sawNoSuchElement = false;
            this.sawCall = false;
            super.visit(obj);
            if (!this.sawNoSuchElement) {
                this.bugReporter.reportBug(new BugInstance(this, "IT_NO_SUCH_ELEMENT", this.sawCall ? 3 : 2).addClassAndMethod(this));
            }
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 187 && this.getClassConstantOperand().equals("java/util/NoSuchElementException")) {
            this.sawNoSuchElement = true;
        } else if (seen == 183 || seen == 182 || seen == 185) {
            this.sawCall = true;
            if (this.getNameConstantOperand().toLowerCase().indexOf("next") >= 0 || this.getNameConstantOperand().toLowerCase().indexOf("previous") >= 0) {
                this.sawNoSuchElement = true;
            }
        }
    }
}

