/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.guitar.model.wrapper;

import edu.umd.cs.guitar.model.GHashcodeGenerator;
import edu.umd.cs.guitar.model.data.AttributesType;
import edu.umd.cs.guitar.model.data.GUIStructure;
import edu.umd.cs.guitar.model.data.GUIType;
import edu.umd.cs.guitar.model.wrapper.ComponentTypeWrapper;
import edu.umd.cs.guitar.model.wrapper.GUITypeWrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GUIStructureWrapper {
    GUIStructure dGUIStructure;
    List<GUITypeWrapper> lGUI;

    public void parseData() {
        this.lGUI = new ArrayList<GUITypeWrapper>();
        Set<GUITypeWrapper> listRootWindows = this.getRootWindows();
        for (GUITypeWrapper rootWin : listRootWindows) {
            this.lGUI.add(rootWin);
            rootWin.parseData(this.dGUIStructure, this);
        }
    }

    public GUIStructureWrapper(GUIStructure data) {
        this.dGUIStructure = data;
    }

    public void addGUI(GUIType dGUI) {
        this.dGUIStructure.getGUI().add(dGUI);
    }

    public void addGUI(GUITypeWrapper mGUI) {
        this.dGUIStructure.getGUI().add(mGUI.getData());
    }

    public void removeGUI(GUITypeWrapper mGUI) {
        List<GUIType> tempGUIList = this.dGUIStructure.getGUI();
        tempGUIList.remove(mGUI.getData());
        this.dGUIStructure.setGUI(tempGUIList);
    }

    public GUITypeWrapper getGUIByTitle(String sTitle) {
        List<GUIType> lGUI = this.dGUIStructure.getGUI();
        for (GUIType gui : lGUI) {
            GUITypeWrapper guiA = new GUITypeWrapper(gui);
            String sGUITitle = guiA.getTitle();
            if (!sTitle.equals(sGUITitle)) continue;
            return guiA;
        }
        return null;
    }

    public boolean contains(GUITypeWrapper obj) {
        if (!(obj instanceof GUITypeWrapper)) {
            return false;
        }
        for (GUIType gui : this.dGUIStructure.getGUI()) {
            GUITypeWrapper guiA = new GUITypeWrapper(gui);
            if (!guiA.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public GUIStructure getData() {
        return this.dGUIStructure;
    }

    public GUITypeWrapper getRoot() {
        Set<GUITypeWrapper> guiList = this.getRootWindows();
        if (guiList == null) {
            return null;
        }
        if (guiList.size() == 0) {
            // empty if block
        }
        return (GUITypeWrapper)guiList.toArray()[0];
    }

    public ComponentTypeWrapper getComponentFromID(String ID) {
        GUITypeWrapper wGUI;
        ComponentTypeWrapper retComp = null;
        List<GUITypeWrapper> lGUIType = this.lGUI;
        if (lGUIType == null) {
            this.parseData();
        }
        Iterator<GUITypeWrapper> i$ = lGUIType.iterator();
        while (i$.hasNext() && (retComp = (wGUI = i$.next()).getChildByID(ID)) == null) {
        }
        return retComp;
    }

    public void addValueBySignature(AttributesType signature, String name, Set<String> values) {
        for (GUIType dGUI : this.dGUIStructure.getGUI()) {
            GUITypeWrapper wGUI = new GUITypeWrapper(dGUI);
            wGUI.addValueBySignature(signature, name, values);
        }
    }

    public void addValueBySignature(AttributesType signature, String name, String value) {
        HashSet<String> values = new HashSet<String>();
        values.add(value);
        this.addValueBySignature(signature, name, values);
    }

    public void updateValueBySignature(AttributesType signature, String name, String value) {
        HashSet<String> values = new HashSet<String>();
        values.add(value);
        this.updateValueBySignature(signature, name, values);
    }

    public void updateValueBySignature(AttributesType signature, String name, Set<String> values) {
        for (GUIType dGUI : this.dGUIStructure.getGUI()) {
            GUITypeWrapper wGUI = new GUITypeWrapper(dGUI);
            wGUI.updateValueBySignature(signature, name, values);
        }
    }

    public void updateID() {
        for (GUIType dGUI : this.dGUIStructure.getGUI()) {
            GUITypeWrapper wGUI = new GUITypeWrapper(dGUI);
            wGUI.updateID();
        }
    }

    public void generateID(GHashcodeGenerator hashcodeGenerator) {
        for (GUIType dGUI : this.dGUIStructure.getGUI()) {
            GUITypeWrapper wGUI = new GUITypeWrapper(dGUI);
            wGUI.generateID(hashcodeGenerator);
        }
    }

    public ComponentTypeWrapper getComponentBySignature(AttributesType signature) {
        ComponentTypeWrapper result = null;
        for (GUIType dGUI : this.dGUIStructure.getGUI()) {
            GUITypeWrapper wGUI = new GUITypeWrapper(dGUI);
            result = wGUI.getComponentBySignature(signature);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public void addValueByName(String sTitle, String sName, String sValue) {
        for (GUIType dGUI : this.dGUIStructure.getGUI()) {
            GUITypeWrapper wGUI = new GUITypeWrapper(dGUI);
            wGUI.addValueByName(sTitle, sName, sValue);
        }
    }

    private Set<GUITypeWrapper> getRootWindows() {
        HashSet<GUITypeWrapper> rootWindows = new HashSet<GUITypeWrapper>();
        for (GUIType dGUI : this.dGUIStructure.getGUI()) {
            GUITypeWrapper wGUI = new GUITypeWrapper(dGUI);
            if (!wGUI.isRoot()) continue;
            rootWindows.add(wGUI);
        }
        return rootWindows;
    }

    public Set<GUIType> getRootGUI() {
        HashSet<GUIType> rootGUI = new HashSet<GUIType>();
        for (GUIType dGUI : this.dGUIStructure.getGUI()) {
            GUITypeWrapper wGUI = new GUITypeWrapper(dGUI);
            if (!wGUI.isRoot()) continue;
            rootGUI.add(dGUI);
        }
        return rootGUI;
    }

    public List<GUITypeWrapper> getGUIs() {
        return this.lGUI;
    }

    public int getMaxID() {
        int max = 0;
        for (GUIType dGUI : this.dGUIStructure.getGUI()) {
            GUITypeWrapper wGUI = new GUITypeWrapper(dGUI);
            int iLocalMax = wGUI.getMaxID();
            if (max >= iLocalMax) continue;
            max = iLocalMax;
        }
        return max;
    }
}

