package de.ugoe.cs.eventbench.efg.commands;

import java.io.File;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import de.ugoe.cs.eventbench.CommandHelpers;
import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.efg.GUITARTestCaseParser;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to load a set of sequences from a set of GUITAR test cases.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDefgTestCasesToSequences implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String foldername;
		String sequencesName;
		String efgFileName = null;
		try {
			foldername = (String) parameters.get(0);
			sequencesName = (String) parameters.get(1);
			if (parameters.size() >= 3) {
				efgFileName = (String) parameters.get(2);
			}
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		File folder = new File(foldername);
		// TODO would be more robust with filter
		File[] testcaseFiles = folder.listFiles();
		Collection<List<Event<?>>> sequences = new LinkedList<List<Event<?>>>();
		GUITARTestCaseParser parser;
		if (efgFileName == null) {
			parser = new GUITARTestCaseParser();
		} else {
			parser = new GUITARTestCaseParser(efgFileName);
		}
		for (File testcaseFile : testcaseFiles) {
			Console.traceln("Loading from file "
					+ testcaseFile.getAbsolutePath());
			sequences.add(parser.parseTestCaseFile(testcaseFile));
		}
		if (GlobalDataContainer.getInstance().addData(sequencesName, sequences)) {
			CommandHelpers.dataOverwritten(sequencesName);
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: efgTestCasesToSequences <folder> <sequencesName> {<efgFileName>}");
	}

}
