package de.ugoe.cs.eventbench.models;

import java.util.ArrayList;
import java.util.List;
import org.junit.*;
import static org.junit.Assert.*;

/**
 * The class <code>IncompleteMemoryTest</code> contains tests for the class <code>{@link IncompleteMemory}</code>.
 *
 * @author Steffen Herbold
 * @version 1.0
 */
public class IncompleteMemoryTest {

	@Test
	public void testIncompleteMemory_1()
		throws Exception {
		int length = 1;

		IncompleteMemory<String> result = new IncompleteMemory<String>(length);

		assertNotNull(result);
		assertEquals(0, result.getLast(1).size());
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testIncompleteMemory_2()
		throws Exception {
		int length = 0;

		new IncompleteMemory<String>(length);
	}

	@Test
	public void testGetLast_1()
		throws Exception {
		int length = 2;
		IncompleteMemory<String> fixture = new IncompleteMemory<String>(length);
		fixture.add("1");
		fixture.add("2");
		fixture.add("3");
		int num = -1;

		List<String> result = fixture.getLast(num);

		assertNotNull(result);
		assertEquals(0, result.size());
	}

	@Test
	public void testGetLast_2()
		throws Exception {
		int length = 2;
		IncompleteMemory<String> fixture = new IncompleteMemory<String>(length);
		fixture.add("1");
		fixture.add("2");
		fixture.add("3");
		int num = 1;
		
		List<String> expected = new ArrayList<String>();
		expected.add("3");

		List<String> result = fixture.getLast(num);

		assertNotNull(result);
		assertEquals(expected, result);
	}

	@Test
	public void testGetLast_3()
		throws Exception {
		int length = 2;
		IncompleteMemory<String> fixture = new IncompleteMemory<String>(length);
		fixture.add("1");
		fixture.add("2");
		fixture.add("3");
		int num = 2;
		
		List<String> expected = new ArrayList<String>();
		expected.add("2");
		expected.add("3");

		List<String> result = fixture.getLast(num);

		assertNotNull(result);
		assertEquals(expected, result);
	}
	
	@Test
	public void testGetLast_4()
		throws Exception {
		int length = 2;
		IncompleteMemory<String> fixture = new IncompleteMemory<String>(length);
		fixture.add("1");
		fixture.add("2");
		fixture.add("3");
		int num = 3;
		
		List<String> expected = new ArrayList<String>();
		expected.add("2");
		expected.add("3");

		List<String> result = fixture.getLast(num);

		assertNotNull(result);
		assertEquals(expected, result);
	}

	@Test
	public void testGetLength_1()
		throws Exception {
		int length = 2;
		IncompleteMemory<String> fixture = new IncompleteMemory<String>(length);
		
		int result = fixture.getLength(); 

		assertEquals(0, result);
	}
	
	@Test
	public void testGetLength_2()
		throws Exception {
		int length = 2;
		IncompleteMemory<String> fixture = new IncompleteMemory<String>(length);
		fixture.add("1");
		
		int result = fixture.getLength(); 

		assertEquals(1, result);
	}
	
	@Test
	public void testGetLength_3()
		throws Exception {
		int length = 2;
		IncompleteMemory<String> fixture = new IncompleteMemory<String>(length);
		fixture.add("1");
		fixture.add("2");
		fixture.add("3");
		
		int result = fixture.getLength(); 

		assertEquals(2, result);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(IncompleteMemoryTest.class);
	}
}