package de.ugoe.cs.util.console.defaultcommands;

import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import org.junit.*;

import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.mock.MockOutputListener;
import static org.junit.Assert.*;

/**
 * The class <code>CMDexitTest</code> contains tests for the class
 * <code>{@link CMDexit}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDexitTest {

	final static String ENDLINE = System.getProperty("line.separator");

	private static class ExitException extends SecurityException {
		private static final long serialVersionUID = 1L;
	}

	private static class NoExitSecurityManager extends SecurityManager {
		@Override
		public void checkPermission(Permission perm) {
			// allow anything.
		}

		@Override
		public void checkPermission(Permission perm, Object context) {
			// allow anything.
		}

		@Override
		public void checkExit(int status) {
			super.checkExit(status);
			throw new ExitException();
		}
	}

	@Test
	public void testHelp_1() throws Exception {
		CMDexit fixture = new CMDexit();
		MockOutputListener mockListener = new MockOutputListener();
		Console.getInstance().registerOutputListener(mockListener);
		String expected = "Usage: exit" + ENDLINE;

		fixture.help();

		assertEquals(expected, mockListener.getLastOutput());
	}

	@Test(expected = ExitException.class)
	public void testRun_1() throws Exception {
		CMDexit fixture = new CMDexit();
		List<Object> parameters = new ArrayList<Object>();

		fixture.run(parameters);
	}

	@Test(expected = ExitException.class)
	public void testRun_2() throws Exception {
		CMDexit fixture = new CMDexit();
		List<Object> parameters = new ArrayList<Object>();
		parameters.add("test");

		fixture.run(parameters);
	}

	@Before
	public void setUp() throws Exception {
		System.setSecurityManager(new NoExitSecurityManager());
	}

	@After
	public void tearDown() throws Exception {
		System.setSecurityManager(null);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(CMDexitTest.class);
	}
}