/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.guitar.model;

import edu.umd.cs.guitar.exception.ApplicationConnectException;
import edu.umd.cs.guitar.model.GComponent;
import edu.umd.cs.guitar.model.GWindow;
import edu.umd.cs.guitar.model.data.ComponentType;
import edu.umd.cs.guitar.model.data.ContainerType;
import edu.umd.cs.guitar.model.data.ContentsType;
import edu.umd.cs.guitar.model.data.GUIStructure;
import edu.umd.cs.guitar.model.data.GUIType;
import edu.umd.cs.guitar.model.data.ObjectFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class GApplication {
    private static ObjectFactory factory = new ObjectFactory();

    public abstract void connect() throws ApplicationConnectException;

    public abstract void connect(String[] var1) throws ApplicationConnectException;

    public abstract Set<GWindow> getAllWindow();

    public GUIStructure getCurrentState() {
        GUIStructure guiStructure = factory.createGUIStructure();
        Set<GWindow> lWindows = this.getAllWindow();
        ArrayList<GUIType> lGUIs = new ArrayList<GUIType>();
        for (GWindow gWindow : lWindows) {
            if (!gWindow.isValid()) continue;
            GUIType dGUI = this.extractDeepGUI(gWindow);
            lGUIs.add(dGUI);
        }
        guiStructure.setGUI(lGUIs);
        return guiStructure;
    }

    private GUIType extractDeepGUI(GWindow gWindow) {
        GUIType retGUI = gWindow.extractWindow();
        GComponent gWinContainer = gWindow.getContainer();
        ComponentType container = null;
        container = this.extractDeepGUI(gWinContainer);
        if (container != null) {
            retGUI.getContainer().getContents().getWidgetOrContainer().add(container);
        }
        return retGUI;
    }

    private ComponentType extractDeepGUI(GComponent component) {
        ComponentType retComp = component.extractProperties();
        if (retComp instanceof ContainerType) {
            ContainerType container = (ContainerType)retComp;
            ContentsType contents = factory.createContentsType();
            container.setContents(contents);
            List<GComponent> children = component.getChildren();
            ArrayList<ComponentType> childrenComp = new ArrayList<ComponentType>();
            for (GComponent aChild : children) {
                ComponentType childComp = this.extractDeepGUI(aChild);
                childrenComp.add(childComp);
            }
            contents.setWidgetOrContainer(childrenComp);
        }
        return retComp;
    }

    public Set<String> getCurrentWinID() {
        Set<GWindow> allWins = this.getAllWindow();
        HashSet<String> allWinIDs = new HashSet<String>();
        for (GWindow win : allWins) {
            allWinIDs.add(win.getTitle());
        }
        return allWinIDs;
    }
}

