package de.ugoe.cs.eventbench;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.junit.*;

import static org.junit.Assert.*;

import de.ugoe.cs.eventbench.data.Event;


/**
 * The class <code>SequenceInstanceOfTest</code> contains tests for the
 * class <code>{@link SequenceInstanceOf}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class SequenceInstanceOfTest {
	
	@Test
	public void TestIsCollectionOfSequences_1() throws Exception {
		Collection<List<? extends Event<?>>> sequences = new LinkedList<List<? extends Event<?>>>();
		List<Event<?>> sequence1 = new ArrayList<Event<?>>();
		sequence1.add(new Event<String>("a"));
		sequences.add(sequence1);
		
		boolean result = SequenceInstanceOf.isCollectionOfSequences(sequences);
		assertTrue(result);
	}
	
	@Test
	public void TestIsCollectionOfSequences_2() throws Exception {
		Collection<List<? extends Event<?>>> sequences = new LinkedList<List<? extends Event<?>>>();
		List<Event<?>> sequence1 = new ArrayList<Event<?>>();
		sequences.add(sequence1);
		
		boolean result = SequenceInstanceOf.isCollectionOfSequences(sequences);
		assertFalse(result);
	}
	
	@Test
	public void TestIsCollectionOfSequences_3() throws Exception {
		Collection<List<? extends Event<?>>> sequences = new LinkedList<List<? extends Event<?>>>();
		
		boolean result = SequenceInstanceOf.isCollectionOfSequences(sequences);
		assertFalse(result);
	}
	
	@Test
	public void TestIsCollectionOfSequences_4() throws Exception {
		boolean result = SequenceInstanceOf.isCollectionOfSequences(null);
		assertFalse(result);
	}
	
	@Test
	public void TestIsCollectionOfSequences_5() throws Exception {
		boolean result = SequenceInstanceOf.isCollectionOfSequences(new Object());
		assertFalse(result);
	}
	
	@Test
	public void TestIsEventSequence_1() throws Exception {
		List<Event<?>> sequence = new ArrayList<Event<?>>();
		sequence.add(new Event<String>("a"));
		
		boolean result = SequenceInstanceOf.isEventSequence(sequence);
		assertTrue(result);
	}
	
	@Test
	public void TestIsEventSequence_2() throws Exception {
		List<Event<?>> sequence = new ArrayList<Event<?>>();
		
		boolean result = SequenceInstanceOf.isEventSequence(sequence);
		assertFalse(result);
	}
	
	@Test
	public void TestIsEventSequence_3() throws Exception {
		boolean result = SequenceInstanceOf.isEventSequence(null);
		assertFalse(result);
	}
	
	@Test
	public void TestIsEventSequence_4() throws Exception {
		boolean result = SequenceInstanceOf.isEventSequence(new Object());
		assertFalse(result);
	}
	
	
	
	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(SequenceInstanceOfTest.class);
	}
}
