/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.filters;

import edu.uci.ics.jung.algorithms.filters.Filter;
import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import org.apache.commons.collections15.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertexPredicateFilter<V, E>
implements Filter<V, E> {
    protected Predicate<V> vertex_pred;

    public VertexPredicateFilter(Predicate<V> vertex_pred) {
        this.vertex_pred = vertex_pred;
    }

    @Override
    public Graph<V, E> transform(Graph<V, E> g) {
        Graph filtered;
        try {
            filtered = (Graph)g.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to create copy of existing graph: ", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to create copy of existing graph: ", e);
        }
        for (Object v : g.getVertices()) {
            if (!this.vertex_pred.evaluate(v)) continue;
            filtered.addVertex(v);
        }
        Collection filtered_vertices = filtered.getVertices();
        for (Object e : g.getEdges()) {
            Collection incident = g.getIncidentVertices(e);
            if (!filtered_vertices.containsAll(incident)) continue;
            filtered.addEdge(e, incident);
        }
        return filtered;
    }
}

