/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.multimap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections15.MultiMap;
import org.apache.commons.collections15.iterators.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiHashMap<K, V>
implements MultiMap<K, V>,
Serializable,
Cloneable {
    private transient Collection values = null;
    private static final long serialVersionUID = 1943563828307035349L;
    private HashMap<K, Collection<V>> internalMap;

    public MultiHashMap() {
        this.internalMap = new HashMap();
    }

    public MultiHashMap(int initialCapacity) {
        this.internalMap = new HashMap(initialCapacity);
    }

    public MultiHashMap(int initialCapacity, float loadFactor) {
        this.internalMap = new HashMap(initialCapacity, loadFactor);
    }

    public MultiHashMap(Map<K, V> mapToCopy) {
        this.internalMap = new HashMap((int)((float)mapToCopy.size() * 1.4f));
        this.putAll(mapToCopy);
    }

    public MultiHashMap(MultiMap<K, V> mapToCopy) {
        this.internalMap = new HashMap((int)((float)mapToCopy.size() * 1.4f));
        for (Map.Entry<K, Collection<V>> entry : mapToCopy.entrySet()) {
            Collection<V> coll = entry.getValue();
            Collection<V> newColl = this.createCollection(coll);
            this.internalMap.put(entry.getKey(), newColl);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        String version = "1.2";
        try {
            version = System.getProperty("java.version");
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (version.startsWith("1.2") || version.startsWith("1.3")) {
            for (Map.Entry<K, Collection<V>> entry : this.entrySet()) {
                this.internalMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public int totalSize() {
        int total = 0;
        Collection<Collection<V>> values = this.internalMap.values();
        for (Collection<V> coll : values) {
            total += coll.size();
        }
        return total;
    }

    public Collection<V> getCollection(Object key) {
        return this.internalMap.get(key);
    }

    @Override
    public int size(Object key) {
        Collection<V> coll = this.getCollection(key);
        if (coll == null) {
            return 0;
        }
        return coll.size();
    }

    @Override
    public Iterator<V> iterator(Object key) {
        Collection<V> coll = this.getCollection(key);
        if (coll == null) {
            return EmptyIterator.INSTANCE;
        }
        return coll.iterator();
    }

    @Override
    public V put(K key, V value) {
        boolean results;
        Collection<V> coll = this.getCollection(key);
        if (coll == null) {
            coll = this.createCollection(null);
            this.internalMap.put(key, coll);
        }
        return (V)((results = coll.add(value)) ? value : null);
    }

    @Override
    public boolean putAll(K key, Collection<? extends V> values) {
        if (values == null || values.size() == 0) {
            return false;
        }
        Collection<Object> coll = this.getCollection(key);
        if (coll == null) {
            coll = this.createCollection(values);
            if (coll.size() == 0) {
                return false;
            }
            this.internalMap.put(key, coll);
            return true;
        }
        return coll.addAll(values);
    }

    @Override
    public boolean containsValue(Object value) {
        Set<Map.Entry<K, Collection<V>>> pairs = this.internalMap.entrySet();
        if (pairs == null) {
            return false;
        }
        for (Map.Entry<K, Collection<V>> keyValuePair : pairs) {
            Collection<V> coll = keyValuePair.getValue();
            if (!coll.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object key, Object value) {
        Collection<V> coll = this.getCollection(key);
        if (coll == null) {
            return false;
        }
        return coll.contains(value);
    }

    @Override
    public V remove(Object key, Object item) {
        Collection<V> valuesForKey = this.getCollection(key);
        if (valuesForKey == null) {
            return null;
        }
        valuesForKey.remove(item);
        if (valuesForKey.isEmpty()) {
            this.remove(key);
        }
        return (V)item;
    }

    @Override
    public void clear() {
        Set<Map.Entry<K, Collection<V>>> pairs = this.internalMap.entrySet();
        for (Map.Entry<K, Collection<V>> keyValuePair : pairs) {
            Collection<V> coll = keyValuePair.getValue();
            coll.clear();
        }
        this.internalMap.clear();
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public Collection<V> get(Object key) {
        return this.internalMap.get(key);
    }

    @Override
    public Collection<V> remove(Object key) {
        return this.internalMap.remove(key);
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalMap.containsKey(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (K key : map.keySet()) {
            this.put(key, map.get(key));
        }
    }

    @Override
    public void putAll(MultiMap<? extends K, ? extends V> map) {
        for (Map.Entry<K, Collection<V>> entry : map.entrySet()) {
            for (V v : entry.getValue()) {
                this.put(entry.getKey(), v);
            }
        }
    }

    @Override
    public Set<K> keySet() {
        return this.internalMap.keySet();
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.internalMap.entrySet();
    }

    @Override
    public Map<K, Collection<V>> map() {
        return this.internalMap;
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Object clone() {
        MultiHashMap<K, V> cloned = new MultiHashMap<K, V>();
        for (Map.Entry<K, Collection<V>> entry : this.internalMap.entrySet()) {
            for (V v : entry.getValue()) {
                cloned.put(entry.getKey(), v);
            }
        }
        return cloned;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MultiHashMap) {
            return this.internalMap.equals(((MultiHashMap)obj).map());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.internalMap.hashCode();
    }

    protected Collection<V> createCollection(Collection<? extends V> coll) {
        if (coll == null) {
            return new ArrayList();
        }
        return new ArrayList<V>(coll);
    }

    public String toString() {
        return this.internalMap.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator<T>
    implements Iterator<V> {
        private Iterator<Collection<V>> backedIterator;
        private Iterator<V> tempIterator;

        private ValueIterator() {
            this.backedIterator = MultiHashMap.this.internalMap.values().iterator();
        }

        private boolean searchNextIterator() {
            while (this.tempIterator == null || !this.tempIterator.hasNext()) {
                if (!this.backedIterator.hasNext()) {
                    return false;
                }
                this.tempIterator = this.backedIterator.next().iterator();
            }
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.searchNextIterator();
        }

        @Override
        public V next() {
            if (!this.searchNextIterator()) {
                throw new NoSuchElementException();
            }
            return this.tempIterator.next();
        }

        @Override
        public void remove() {
            if (this.tempIterator == null) {
                throw new IllegalStateException();
            }
            this.tempIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values<T>
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            int compt = 0;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                it.next();
                ++compt;
            }
            return compt;
        }

        @Override
        public void clear() {
            MultiHashMap.this.clear();
        }
    }
}

