/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationWithSourceLines;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.gui2.AboutDialog;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.SourceCodeDisplay;
import edu.umd.cs.findbugs.util.LaunchBrowser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class MainFrameComponentFactory
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(MainFrameComponentFactory.class.getName());
    private final MainFrame mainFrame;
    private URL sourceLink;
    private boolean listenerAdded = false;

    public MainFrameComponentFactory(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    JPanel statusBar() {
        JPanel statusBar = new JPanel();
        statusBar.setBorder(new BevelBorder(1));
        statusBar.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        statusBar.add((Component)this.mainFrame.getStatusBarLabel(), constraints.clone());
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(0, 5, 0, 5);
        JLabel logoLabel = new JLabel();
        constraints.insets = new Insets(0, 0, 0, 0);
        ImageIcon logoIcon = new ImageIcon(MainFrame.class.getResource("logo_umd.png"));
        logoLabel.setIcon(logoIcon);
        logoLabel.setPreferredSize(new Dimension(logoIcon.getIconWidth(), logoIcon.getIconHeight()));
        constraints.anchor = 17;
        statusBar.add((Component)logoLabel, constraints.clone());
        return statusBar;
    }

    JSplitPane summaryTab() {
        this.mainFrame.setSummaryTopPanel(new JPanel());
        this.mainFrame.getSummaryTopPanel().setLayout(new GridLayout(0, 1));
        this.mainFrame.getSummaryTopPanel().setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        JPanel summaryTopOuter = new JPanel(new BorderLayout());
        summaryTopOuter.add((Component)this.mainFrame.getSummaryTopPanel(), "North");
        this.mainFrame.getSummaryHtmlArea().setContentType("text/html");
        this.mainFrame.getSummaryHtmlArea().setEditable(false);
        this.mainFrame.getSummaryHtmlArea().addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                AboutDialog.editorPaneHyperlinkUpdate(evt);
            }
        });
        this.setStyleSheets();
        JScrollPane summaryScrollPane = new JScrollPane(summaryTopOuter);
        summaryScrollPane.getVerticalScrollBar().setUnitIncrement((int)Driver.getFontSize());
        JSplitPane splitP = new JSplitPane(1, false, summaryScrollPane, this.mainFrame.getSummaryHtmlScrollPane());
        splitP.setContinuousLayout(true);
        splitP.setDividerLocation(GUISaveState.getInstance().getSplitSummary());
        splitP.setOneTouchExpandable(true);
        splitP.setUI(new BasicSplitPaneUI(){

            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    public void setBorder(Border b) {
                    }
                };
            }
        });
        splitP.setBorder(null);
        return splitP;
    }

    private void setStyleSheets() {
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.addRule("body {font-size: " + Driver.getFontSize() + "pt}");
        styleSheet.addRule("H1 {color: red;  font-size: 120%; font-weight: bold;}");
        styleSheet.addRule("code {font-family: courier; font-size: " + Driver.getFontSize() + "pt}");
        styleSheet.addRule(" a:link { color: #0000FF; } ");
        styleSheet.addRule(" a:visited { color: #800080; } ");
        styleSheet.addRule(" a:active { color: #FF0000; text-decoration: underline; } ");
        HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
        htmlEditorKit.setStyleSheet(styleSheet);
        this.mainFrame.summaryHtmlArea.setEditorKit(htmlEditorKit);
    }

    JPanel createCommentsInputPanel() {
        return this.mainFrame.getComments().createCommentsInputPanel();
    }

    JPanel createSourceCodePanel() {
        Font sourceFont = new Font("Monospaced", 0, (int)Driver.getFontSize());
        this.mainFrame.getSourceCodeTextPane().setFont(sourceFont);
        this.mainFrame.getSourceCodeTextPane().setEditable(false);
        this.mainFrame.getSourceCodeTextPane().getCaret().setSelectionVisible(true);
        this.mainFrame.getSourceCodeTextPane().setDocument(SourceCodeDisplay.SOURCE_NOT_RELEVANT);
        JScrollPane sourceCodeScrollPane = new JScrollPane(this.mainFrame.getSourceCodeTextPane());
        sourceCodeScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)sourceCodeScrollPane, "Center");
        panel.revalidate();
        if (MainFrame.GUI2_DEBUG) {
            System.out.println("Created source code panel");
        }
        return panel;
    }

    JPanel createSourceSearchPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel thePanel = new JPanel();
        thePanel.setLayout(gridbag);
        this.mainFrame.getFindButton().setToolTipText("Find first occurrence");
        this.mainFrame.getFindNextButton().setToolTipText("Find next occurrence");
        this.mainFrame.getFindPreviousButton().setToolTipText("Find previous occurrence");
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 5, 0, 5);
        c.fill = 2;
        gridbag.setConstraints(this.mainFrame.getSourceSearchTextField(), c);
        thePanel.add(this.mainFrame.getSourceSearchTextField());
        this.mainFrame.getFindButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrameComponentFactory.this.mainFrame.searchSource(0);
            }
        });
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 0;
        gridbag.setConstraints(this.mainFrame.getFindButton(), c);
        thePanel.add(this.mainFrame.getFindButton());
        this.mainFrame.getFindNextButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrameComponentFactory.this.mainFrame.searchSource(1);
            }
        });
        c.gridx = 2;
        c.weightx = 0.0;
        c.fill = 0;
        gridbag.setConstraints(this.mainFrame.getFindNextButton(), c);
        thePanel.add(this.mainFrame.getFindNextButton());
        this.mainFrame.getFindPreviousButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrameComponentFactory.this.mainFrame.searchSource(2);
            }
        });
        c.gridx = 3;
        c.weightx = 0.0;
        c.fill = 0;
        gridbag.setConstraints(this.mainFrame.getFindPreviousButton(), c);
        thePanel.add(this.mainFrame.getFindPreviousButton());
        return thePanel;
    }

    void setSourceTab(String title, @CheckForNull BugInstance bug) {
        JComponent label = this.mainFrame.getGuiLayout().getSourceViewComponent();
        if (label != null) {
            Cloud plugin;
            URL u = null;
            if (bug != null && (plugin = this.mainFrame.getBugCollection().getCloud()).supportsSourceLinks()) {
                u = plugin.getSourceLink(bug);
            }
            if (u != null) {
                this.addLink(label, u);
            } else {
                this.removeLink(label);
            }
        }
        this.mainFrame.getGuiLayout().setSourceTitle(title);
    }

    private void addLink(JComponent component, URL source) {
        this.sourceLink = source;
        component.setEnabled(true);
        if (!this.listenerAdded) {
            this.listenerAdded = true;
            component.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    URL u = MainFrameComponentFactory.this.sourceLink;
                    if (u != null) {
                        LaunchBrowser.showDocument(u);
                    }
                }
            });
        }
        component.setCursor(new Cursor(12));
        Cloud plugin = this.mainFrame.getBugCollection().getCloud();
        if (plugin != null) {
            component.setToolTipText(plugin.getSourceLinkToolTip(null));
        }
    }

    private void removeLink(JComponent component) {
        this.sourceLink = null;
        component.setEnabled(false);
        component.setCursor(new Cursor(0));
        component.setToolTipText("");
    }

    void initializeGUI() {
        SwingUtilities.invokeLater(new InitializeGUI(this.mainFrame));
    }

    Component bugSummaryComponent(BugAnnotation value, BugInstance bug) {
        JLabel label = new JLabel();
        label.setFont(label.getFont().deriveFont(Driver.getFontSize()));
        label.setFont(label.getFont().deriveFont(0));
        label.setForeground(Color.BLACK);
        ClassAnnotation primaryClass = bug.getPrimaryClass();
        String sourceCodeLabel = L10N.getLocalString("summary.source_code", "source code.");
        String summaryLine = L10N.getLocalString("summary.line", "Line");
        String summaryLines = L10N.getLocalString("summary.lines", "Lines");
        String clickToGoToText = L10N.getLocalString("tooltip.click_to_go_to", "Click to go to");
        if (value instanceof SourceLineAnnotation) {
            SourceLineAnnotation link = (SourceLineAnnotation)value;
            if (this.sourceCodeExists(link)) {
                String srcStr = "";
                int start = link.getStartLine();
                int end = link.getEndLine();
                if (start < 0 && end < 0) {
                    srcStr = sourceCodeLabel;
                } else if (start == end) {
                    srcStr = " [" + summaryLine + " " + start + "]";
                } else if (start < end) {
                    srcStr = " [" + summaryLines + " " + start + " - " + end + "]";
                }
                label.setToolTipText(clickToGoToText + " " + srcStr);
                label.addMouseListener(new BugSummaryMouseListener(bug, label, link));
            }
            label.setText(link.toString());
        } else if (value instanceof BugAnnotationWithSourceLines) {
            BugAnnotationWithSourceLines note = (BugAnnotationWithSourceLines)value;
            SourceLineAnnotation link = note.getSourceLines();
            String srcStr = "";
            if (link != null && this.sourceCodeExists(link)) {
                int start = link.getStartLine();
                int end = link.getEndLine();
                if (start < 0 && end < 0) {
                    srcStr = sourceCodeLabel;
                } else if (start == end) {
                    srcStr = " [" + summaryLine + " " + start + "]";
                } else if (start < end) {
                    srcStr = " [" + summaryLines + " " + start + " - " + end + "]";
                }
                if (!srcStr.equals("")) {
                    label.setToolTipText(clickToGoToText + " " + srcStr);
                    label.addMouseListener(new BugSummaryMouseListener(bug, label, link));
                }
            }
            String noteText = note == bug.getPrimaryMethod() || note == bug.getPrimaryField() ? note.toString() : note.toString(primaryClass);
            if (!srcStr.equals(sourceCodeLabel)) {
                label.setText(noteText + srcStr);
            } else {
                label.setText(noteText);
            }
        } else {
            label.setText(value.toString(primaryClass));
        }
        return label;
    }

    public Component bugSummaryComponent(String str, BugInstance bug) {
        JLabel label = new JLabel();
        label.setFont(label.getFont().deriveFont(Driver.getFontSize()));
        label.setFont(label.getFont().deriveFont(0));
        label.setForeground(Color.BLACK);
        label.setText(str);
        SourceLineAnnotation link = bug.getPrimarySourceLineAnnotation();
        if (link != null) {
            label.addMouseListener(new BugSummaryMouseListener(bug, label, link));
        }
        return label;
    }

    private boolean sourceCodeExists(@Nonnull SourceLineAnnotation note) {
        try {
            this.mainFrame.getProject().getSourceFinder().findSourceFile(note);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private class BugSummaryMouseListener
    extends MouseAdapter {
        private final BugInstance bugInstance;
        private final JLabel label;
        private final SourceLineAnnotation note;

        BugSummaryMouseListener(@Nonnull BugInstance bugInstance, @Nonnull JLabel label, SourceLineAnnotation link) {
            this.bugInstance = bugInstance;
            this.label = label;
            this.note = link;
        }

        public void mouseClicked(MouseEvent e) {
            MainFrameComponentFactory.this.mainFrame.getSourceCodeDisplayer().displaySource(this.bugInstance, this.note);
        }

        public void mouseEntered(MouseEvent e) {
            this.label.setForeground(Color.blue);
            MainFrameComponentFactory.this.mainFrame.setCursor(new Cursor(12));
        }

        public void mouseExited(MouseEvent e) {
            this.label.setForeground(Color.black);
            MainFrameComponentFactory.this.mainFrame.setCursor(new Cursor(0));
        }
    }

    private static class InitializeGUI
    implements Runnable {
        private MainFrame mainFrame;

        public InitializeGUI(MainFrame mainFrame) {
            this.mainFrame = mainFrame;
        }

        public void run() {
            this.mainFrame.setTitle("FindBugs");
            try {
                this.mainFrame.getGuiLayout().initialize();
            }
            catch (Exception e) {
                if (!UIManager.getLookAndFeel().getName().equals("Metal")) {
                    System.err.println("Exception caught initializing GUI; reverting to CrossPlatformLookAndFeel");
                    try {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    }
                    catch (Exception e2) {
                        System.err.println("Exception while setting CrossPlatformLookAndFeel: " + e2);
                        throw new Error(e2);
                    }
                    this.mainFrame.getGuiLayout().initialize();
                }
                throw new Error(e);
            }
            this.mainFrame.mainFrameTree.setBugPopupMenu(this.mainFrame.mainFrameTree.createBugPopupMenu());
            this.mainFrame.mainFrameTree.setBranchPopupMenu(this.mainFrame.mainFrameTree.createBranchPopUpMenu());
            this.mainFrame.updateStatusBar();
            Rectangle bounds = GUISaveState.getInstance().getFrameBounds();
            if (bounds != null) {
                this.mainFrame.setBounds(bounds);
            }
            this.mainFrame.setExtendedState(GUISaveState.getInstance().getExtendedWindowState());
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
            this.mainFrame.setDefaultCloseOperation(0);
            this.mainFrame.setJMenuBar(this.mainFrame.mainFrameMenu.createMainMenuBar());
            this.mainFrame.setVisible(true);
            this.mainFrame.getMainFrameLoadSaveHelper().initialize();
            JToolTip tempToolTip = this.mainFrame.mainFrameTree.getTableheader().createToolTip();
            UIManager.put("ToolTip.font", new FontUIResource(tempToolTip.getFont().deriveFont(Driver.getFontSize())));
            this.setupOSX();
            String loadFromURL = SystemProperties.getOSDependentProperty("findbugs.loadBugsFromURL");
            if (loadFromURL != null) {
                try {
                    loadFromURL = SystemProperties.rewriteURLAccordingToProperties(loadFromURL);
                    URL url = new URL(loadFromURL);
                    this.mainFrame.getMainFrameLoadSaveHelper().loadAnalysis(url);
                }
                catch (MalformedURLException e1) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Error loading " + loadFromURL);
                }
            }
            this.mainFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    InitializeGUI.this.mainFrame.callOnClose();
                }
            });
            Driver.removeSplashScreen();
            this.mainFrame.waitForMainFrameInitialized();
        }

        private void setupOSX() {
            block5: {
                if (MainFrame.MAC_OS_X) {
                    try {
                        this.mainFrame.mainFrameMenu.initOSX();
                        this.mainFrame.mainFrameMenu.enablePreferencesMenuItem(true);
                    }
                    catch (NoClassDefFoundError e) {
                        System.err.println("This version of Mac OS X does not support the Apple EAWT. Application Menu handling has been disabled (" + e + ")");
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("This version of Mac OS X does not support the Apple EAWT. Application Menu handling has been disabled (" + e + ")");
                    }
                    catch (Exception e) {
                        System.err.println("Exception while loading the OSXAdapter: " + e);
                        e.printStackTrace();
                        if (!MainFrame.GUI2_DEBUG) break block5;
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

