/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.Confidence;
import edu.umd.cs.findbugs.annotations.DesireNoWarning;
import edu.umd.cs.findbugs.annotations.DesireWarning;
import edu.umd.cs.findbugs.annotations.ExpectWarning;
import edu.umd.cs.findbugs.annotations.NoWarning;
import edu.umd.cs.findbugs.annotations.Priority;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.classfile.analysis.EnumValue;
import edu.umd.cs.findbugs.plan.AnalysisPass;
import edu.umd.cs.findbugs.plan.ExecutionPlan;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.CheckForNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckExpectedWarnings
implements Detector2,
NonReportingDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean("cew.debug");
    private BugReporter reporter;
    private final BugCollection bugCollection;
    private Set<String> possibleBugCodes;
    private Map<MethodDescriptor, Collection<BugInstance>> warningsByMethod;
    private ClassDescriptor expectWarning;
    private ClassDescriptor noWarning;
    private ClassDescriptor desireWarning;
    private ClassDescriptor desireNoWarning;
    private boolean warned;

    public CheckExpectedWarnings(BugReporter bugReporter) {
        this.bugCollection = bugReporter.getBugCollection();
        if (this.bugCollection != null) {
            this.reporter = bugReporter;
            this.expectWarning = DescriptorFactory.createClassDescriptor(ExpectWarning.class);
            this.noWarning = DescriptorFactory.createClassDescriptor(NoWarning.class);
            this.desireWarning = DescriptorFactory.createClassDescriptor(DesireWarning.class);
            this.desireNoWarning = DescriptorFactory.createClassDescriptor(DesireNoWarning.class);
        }
    }

    @Override
    public void visitClass(ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        if (this.reporter == null) {
            if (!this.warned) {
                System.err.println("*** NOTE ***: CheckExpectedWarnings disabled because bug reporter doesn't use a BugCollection");
                this.warned = true;
            }
            return;
        }
        if (this.warningsByMethod == null) {
            this.warningsByMethod = new HashMap<MethodDescriptor, Collection<BugInstance>>();
            for (BugInstance warning : this.bugCollection) {
                MethodAnnotation method = warning.getPrimaryMethod();
                if (method == null) continue;
                MethodDescriptor methodDescriptor = method.toXMethod().getMethodDescriptor();
                Collection<BugInstance> warnings = this.warningsByMethod.get(methodDescriptor);
                if (warnings == null) {
                    warnings = new LinkedList<BugInstance>();
                    this.warningsByMethod.put(methodDescriptor, warnings);
                }
                warnings.add(warning);
            }
            this.possibleBugCodes = new HashSet<String>();
            ExecutionPlan executionPlan = Global.getAnalysisCache().getDatabase(ExecutionPlan.class);
            Iterator<AnalysisPass> i = executionPlan.passIterator();
            while (i.hasNext()) {
                AnalysisPass pass = i.next();
                Iterator<DetectorFactory> iterator = pass.iterator();
                while (iterator.hasNext()) {
                    DetectorFactory factory = iterator.next();
                    Set<BugPattern> reportedPatterns = factory.getReportedBugPatterns();
                    for (BugPattern pattern : reportedPatterns) {
                        this.possibleBugCodes.add(pattern.getType());
                        this.possibleBugCodes.add(pattern.getAbbrev());
                    }
                }
            }
            if (DEBUG) {
                System.out.println("CEW: possible warnings are " + this.possibleBugCodes);
            }
        }
        XClass xclass = Global.getAnalysisCache().getClassAnalysis(XClass.class, classDescriptor);
        List<? extends XMethod> methods = xclass.getXMethods();
        for (XMethod xMethod : methods) {
            if (DEBUG) {
                System.out.println("CEW: checking " + xMethod.toString());
            }
            this.check(xMethod, this.expectWarning, true, 1);
            this.check(xMethod, this.desireWarning, true, 2);
            this.check(xMethod, this.noWarning, false, 1);
            this.check(xMethod, this.desireNoWarning, false, 2);
        }
    }

    private void check(XMethod xmethod, ClassDescriptor annotation, boolean expectWarnings, int priority) {
        block12: {
            int minPriority;
            Integer rank;
            Integer num;
            String expectedBugCodes;
            block13: {
                Collection<SourceLineAnnotation> bugs;
                block14: {
                    AnnotationValue expect = xmethod.getAnnotation(annotation);
                    if (expect == null) break block12;
                    if (DEBUG) {
                        System.out.println("*** Found " + annotation + " annotation");
                    }
                    expectedBugCodes = (String)expect.getValue("value");
                    EnumValue wantedConfidence = (EnumValue)expect.getValue("confidence");
                    EnumValue wantedPriority = (EnumValue)expect.getValue("priority");
                    num = (Integer)expect.getValue("num");
                    if (num == null) {
                        num = 1;
                    }
                    if ((rank = (Integer)expect.getValue("rank")) == null) {
                        rank = 20;
                    }
                    minPriority = Confidence.LOW.getConfidenceValue();
                    if (wantedConfidence != null) {
                        minPriority = Confidence.valueOf(wantedConfidence.value).getConfidenceValue();
                    } else if (wantedPriority != null) {
                        minPriority = Priority.valueOf(wantedPriority.value).getPriorityValue();
                    }
                    if (expectedBugCodes != null && expectedBugCodes.trim().length() != 0) break block13;
                    bugs = this.countWarnings(xmethod.getMethodDescriptor(), null, minPriority, rank);
                    if (!expectWarnings || bugs.size() >= num) break block14;
                    BugInstance bug = new BugInstance(this, "FB_MISSING_EXPECTED_WARNING", priority).addClassAndMethod(xmethod.getMethodDescriptor()).addString("any bug");
                    if (!bugs.isEmpty()) {
                        bug.addString(String.format("Expected %d bugs, saw %d", num, bugs.size()));
                    }
                    this.reporter.reportBug(bug);
                    break block12;
                }
                if (expectWarnings || bugs.size() < num) break block12;
                for (SourceLineAnnotation s : bugs) {
                    this.reporter.reportBug(new BugInstance(this, "FB_UNEXPECTED_WARNING", priority).addClassAndMethod(xmethod.getMethodDescriptor()).addString("any bug").add(s));
                }
                break block12;
            }
            StringTokenizer tok = new StringTokenizer(expectedBugCodes, ",");
            while (tok.hasMoreTokens()) {
                String bugCode = tok.nextToken().trim();
                if (!this.possibleBugCodes.contains(bugCode)) continue;
                Collection<SourceLineAnnotation> bugs = this.countWarnings(xmethod.getMethodDescriptor(), bugCode, minPriority, rank);
                if (expectWarnings && bugs.size() < num) {
                    BugInstance bug = new BugInstance(this, "FB_MISSING_EXPECTED_WARNING", priority).addClassAndMethod(xmethod.getMethodDescriptor()).addString(bugCode);
                    if (!bugs.isEmpty()) {
                        bug.addString(String.format("Expected %d bugs, saw %d", num, bugs.size()));
                    }
                    this.reporter.reportBug(bug);
                    continue;
                }
                if (expectWarnings || bugs.size() < num) continue;
                for (SourceLineAnnotation s : bugs) {
                    this.reporter.reportBug(new BugInstance(this, "FB_UNEXPECTED_WARNING", priority).addClassAndMethod(xmethod.getMethodDescriptor()).addString(bugCode).add(s));
                }
            }
        }
    }

    private Collection<SourceLineAnnotation> countWarnings(MethodDescriptor methodDescriptor, @CheckForNull String bugCode, int desiredPriority, int rank) {
        Collection<BugInstance> warnings = this.warningsByMethod.get(methodDescriptor);
        HashSet<SourceLineAnnotation> matching = new HashSet<SourceLineAnnotation>();
        DetectorFactoryCollection i18n = DetectorFactoryCollection.instance();
        boolean matchPattern = false;
        try {
            i18n.getBugCode(bugCode);
        }
        catch (IllegalArgumentException e) {
            matchPattern = true;
        }
        if (warnings != null) {
            for (BugInstance warning : warnings) {
                if (warning.getPriority() > desiredPriority || warning.getBugRank() > rank) continue;
                if (bugCode == null) {
                    matching.add(warning.getPrimarySourceLineAnnotation());
                    continue;
                }
                BugPattern pattern = warning.getBugPattern();
                String match = matchPattern ? pattern.getType() : pattern.getAbbrev();
                if (!match.equals(bugCode)) continue;
                matching.add(warning.getPrimarySourceLineAnnotation());
            }
        }
        return matching;
    }

    @Override
    public void finishPass() {
        HashSet<BugPattern> claimedReported = new HashSet<BugPattern>();
        for (DetectorFactory d : DetectorFactoryCollection.instance().getFactories()) {
            claimedReported.addAll(d.getReportedBugPatterns());
        }
        for (BugPattern b : DetectorFactoryCollection.instance().getBugPatterns()) {
            String category = b.getCategory();
            if (b.isDeprecated() || category.equals("EXPERIMENTAL") || claimedReported.contains(b)) continue;
            AnalysisContext.logError("No detector claims " + b.getType());
        }
    }

    @Override
    public String getDetectorClassName() {
        return CheckExpectedWarnings.class.getName();
    }
}

