package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.CommandHelpers;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.FileOutputListener;

/**
 * <p>
 * Command to stop a {@link FileOutputListener}.
 * </p>
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDstopFileListener implements Command {

	@Override
	public void run(List<Object> parameters) {
		String filename;
		try {
			filename = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		Object dataObject = GlobalDataContainer.getInstance().getData(filename);
		if( dataObject==null ) {
			CommandHelpers.objectNotFoundMessage(filename);
			return;
		}
		if( !(dataObject instanceof FileOutputListener) ) {
			CommandHelpers.objectNotType(filename, "FileOutputListener");
			return;
		}
		
		FileOutputListener listener = (FileOutputListener) dataObject;
		listener.stop();
		GlobalDataContainer.getInstance().removeData(filename);
	}

	@Override
	public void help() {
		Console.println("Command: stopFileListener <filename>");

	}

}
