/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationWithSourceLines;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import org.dom4j.DocumentException;

public class CopyBuggySource {
    private static final String USAGE = "Usage: <cmd>   <bugs.xml> <destinationSrcDir>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, DocumentException {
        FindBugs.setNoAnalysis();
        DetectorFactoryCollection.instance();
        if (args.length != 2) {
            System.out.println(USAGE);
            return;
        }
        SortedBugCollection origCollection = new SortedBugCollection();
        origCollection.readXML(args[0]);
        File src = new File(args[1]);
        byte[] buf = new byte[4096];
        if (!src.isDirectory()) {
            throw new IllegalArgumentException(args[1] + " is not a source directory");
        }
        Project project = origCollection.getProject();
        SourceFinder sourceFinder = new SourceFinder(project);
        HashSet<String> copied = new HashSet<String>();
        HashSet<String> couldNotFind = new HashSet<String>();
        HashSet<String> couldNotCreate = new HashSet<String>();
        int copyCount = 0;
        for (BugInstance bug : origCollection.getCollection()) {
            Iterator<BugAnnotation> i = bug.annotationIterator();
            while (i.hasNext()) {
                FileOutputStream out;
                InputStream in;
                File dstFile;
                long lastModified;
                String fullName;
                block16: {
                    SourceFile sourceFile;
                    SourceLineAnnotation sourceAnnotation;
                    BugAnnotation ann = i.next();
                    if (ann instanceof BugAnnotationWithSourceLines) {
                        sourceAnnotation = ((BugAnnotationWithSourceLines)ann).getSourceLines();
                    } else {
                        if (!(ann instanceof SourceLineAnnotation)) continue;
                        sourceAnnotation = (SourceLineAnnotation)ann;
                    }
                    if (sourceAnnotation == null || sourceAnnotation.isUnknown()) continue;
                    fullName = SourceFinder.getPlatformName(sourceAnnotation);
                    try {
                        sourceFile = sourceFinder.findSourceFile(sourceAnnotation);
                    }
                    catch (FileNotFoundException e) {
                        if (!couldNotFind.add(fullName)) continue;
                        System.out.println("Did not find " + fullName);
                        continue;
                    }
                    if (!copied.add(fullName)) continue;
                    lastModified = sourceFile.getLastModified();
                    dstFile = new File(src, fullName);
                    if (dstFile.exists()) {
                        System.out.println(dstFile + " already exists");
                        continue;
                    }
                    File parent = dstFile.getParentFile();
                    in = null;
                    out = null;
                    in = sourceFile.getInputStream();
                    if (parent.mkdirs() || parent.isDirectory()) break block16;
                    String path = parent.getPath();
                    if (couldNotCreate.add(path)) {
                        System.out.println("Can't create directory for " + path);
                    }
                    in.close();
                    CopyBuggySource.close(in);
                    CopyBuggySource.close(out);
                    dstFile.setLastModified(lastModified);
                    continue;
                }
                try {
                    int sz;
                    out = new FileOutputStream(dstFile);
                    while ((sz = in.read(buf)) >= 0) {
                        ((OutputStream)out).write(buf, 0, sz);
                    }
                    System.out.println("Copied " + fullName);
                    ++copyCount;
                }
                catch (IOException e) {
                    block17: {
                        try {
                            if (!couldNotFind.add(dstFile.getPath())) break block17;
                            System.out.println("Problem copying " + dstFile);
                            e.printStackTrace(System.out);
                        }
                        catch (Throwable throwable) {
                            CopyBuggySource.close(in);
                            CopyBuggySource.close(out);
                            dstFile.setLastModified(lastModified);
                            throw throwable;
                        }
                    }
                    CopyBuggySource.close(in);
                    CopyBuggySource.close(out);
                    dstFile.setLastModified(lastModified);
                    continue;
                }
                CopyBuggySource.close(in);
                CopyBuggySource.close(out);
                dstFile.setLastModified(lastModified);
            }
        }
        System.out.printf("All done. %d files not found, %d files copied%n", couldNotFind.size(), copyCount);
    }

    public static void close(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

