package de.ugoe.cs.eventbench.data;

import java.util.LinkedList;
import java.util.List;

import junitx.framework.ListAssert;
import de.ugoe.cs.eventbench.IReplayDecorator;
import de.ugoe.cs.eventbench.data.mock.MockReplayable;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

import org.junit.*;
import static org.junit.Assert.*;

/**
 * The class <code>ReplayableEventTest</code> contains tests for the class
 * <code>{@link ReplayableEvent}</code>.
 * 
 * @generatedBy CodePro at 12/20/11 10:17 AM
 * @author Steffen Herbold
 * @version 1.0
 */
public class ReplayableEventTest {

	private static class StubReplayDecorator implements IReplayDecorator {

		private static final long serialVersionUID = 1L;

		@Override
		public String getHeader() {
			return null;
		}

		@Override
		public String getFooter() {
			return null;
		}

		@Override
		public String getSessionHeader(int sessionId) {
			return null;
		}

		@Override
		public String getSessionFooter(int sessionId) {
			return null;
		}
		
	}

	@Test
	public void testReplayableEvent_1() throws Exception {
		String type = "typeString";

		ReplayableEvent<MockReplayable> result = new ReplayableEvent<MockReplayable>(
				type);

		assertNotNull(result);
		assertNotNull(result.replayEvents);
		assertTrue(result.replayEvents.isEmpty());
		assertEquals(true, result.replayValid);
		assertEquals(null, result.decorator);
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testReplayableEvent_2() throws Exception {
		new ReplayableEvent<MockReplayable>(null);
	}

	@Test
	public void testAddReplayEvent_1() throws Exception {
		String type = "typeString";
		String replayableReplay = "replayString";
		String replaybleTarget = "replayTargetString";
		MockReplayable replayable = new MockReplayable(replayableReplay,
				replaybleTarget);
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		fixture.addReplayEvent(replayable);
		
		
		assertEquals(1, fixture.replayEvents.size());
		assertEquals(replayable, fixture.replayEvents.get(0));
	}
	
	@Test
	public void testAddReplayEvent_2() throws Exception {
		String type = "typeString";
		String replayableReplay1 = "replayString1";
		String replayableReplay2 = "replayString2";
		String replaybleTarget1 = "replayTargetString1";
		String replaybleTarget2 = "replayTargetString2";
		MockReplayable replayable1 = new MockReplayable(replayableReplay1,
				replaybleTarget1);
		MockReplayable replayable2 = new MockReplayable(replayableReplay2, replaybleTarget2);
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		fixture.addReplayEvent(replayable1);
		fixture.addReplayEvent(replayable2);
		
		
		assertEquals(2, fixture.replayEvents.size());
		assertEquals(replayable1, fixture.replayEvents.get(0));
		assertEquals(replayable2, fixture.replayEvents.get(1));
	}

	@Test(expected = java.security.InvalidParameterException.class )
	public void testAddReplayEvent_fixture_3() throws Exception {
		String type = "typeString";
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		fixture.addReplayEvent(null);
	}

	@Test
	public void testAddReplaySequence_1() throws Exception {
		String type = "typeString";
		String replayableReplay1 = "replayString1";
		String replayableReplay2 = "replayString2";
		String replaybleTarget1 = "replayTargetString1";
		String replaybleTarget2 = "replayTargetString2";
		MockReplayable replayable1 = new MockReplayable(replayableReplay1,
				replaybleTarget1);
		MockReplayable replayable2 = new MockReplayable(replayableReplay2, replaybleTarget2);
		List<MockReplayable> replaySequence = new LinkedList<MockReplayable>();
		replaySequence.add(replayable1);
		replaySequence.add(replayable2);
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		
		fixture.addReplaySequence(replaySequence);		
		
		assertEquals(2, fixture.replayEvents.size());
		assertEquals(replayable1, fixture.replayEvents.get(0));
		assertEquals(replayable2, fixture.replayEvents.get(1));
	}

	@Test(expected = java.security.InvalidParameterException.class )
	public void testAddReplaySequence_2() throws Exception {
		String type = "typeString";
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		
		fixture.addReplaySequence(null);	
	}

	@Test
	public void testEquals_1() throws Exception {
		String type = "typeString";
		boolean replayValid = true;
		String replayableReplay1 = "replayString1";
		String replayableReplay2 = "replayString2";
		String replayableTarget1 = "replayTargetString1";
		String replayableTarget2 = "replayTargetString2";
		MockReplayable replayable1 = new MockReplayable(replayableReplay1,
				replayableTarget1);
		MockReplayable replayable2 = new MockReplayable(replayableReplay2, replayableTarget2);
		List<MockReplayable> replaySequence = new LinkedList<MockReplayable>();
		replaySequence.add(replayable1);
		replaySequence.add(replayable2);
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		fixture.replayEvents = replaySequence;
		fixture.replayValid = replayValid;
		
		String typeOther = "typeString";
		boolean replayValidOther = true;
		String replayableReplayOther1 = "replayString1";
		String replayableReplayOther2 = "replayString2";
		String replaybleTargetOther1 = "replayTargetString1";
		String replaybleTargetOther2 = "replayTargetString2";
		MockReplayable replayableOther1 = new MockReplayable(replayableReplayOther1,
				replaybleTargetOther1);
		MockReplayable replayableOther2 = new MockReplayable(replayableReplayOther2, replaybleTargetOther2);
		List<MockReplayable> replaySequenceOther = new LinkedList<MockReplayable>();
		replaySequenceOther.add(replayableOther1);
		replaySequenceOther.add(replayableOther2);
		ReplayableEvent<MockReplayable> other = new ReplayableEvent<MockReplayable>(
				typeOther);
		other.replayEvents = replaySequenceOther;
		other.replayValid = replayValidOther;

		boolean result = fixture.equals(other);

		assertEquals(true, result);
	}
	
	@Test
	public void testEquals_2() throws Exception {
		String type = "typeString";
		boolean replayValid = true;
		String replayableReplay1 = "replayString1";
		String replayableReplay2 = "replayString2";
		String replayableTarget1 = "replayTargetString1";
		String replayableTarget2 = "replayTargetString2";
		MockReplayable replayable1 = new MockReplayable(replayableReplay1,
				replayableTarget1);
		MockReplayable replayable2 = new MockReplayable(replayableReplay2, replayableTarget2);
		List<MockReplayable> replaySequence = new LinkedList<MockReplayable>();
		replaySequence.add(replayable1);
		replaySequence.add(replayable2);
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		fixture.replayEvents = replaySequence;
		fixture.replayValid = replayValid;
		
		String typeOther = "typeString2";
		boolean replayValidOther = true;
		String replayableReplayOther1 = "replayString1";
		String replayableReplayOther2 = "replayString2";
		String replaybleTargetOther1 = "replayTargetString1";
		String replaybleTargetOther2 = "replayTargetString2";
		MockReplayable replayableOther1 = new MockReplayable(replayableReplayOther1,
				replaybleTargetOther1);
		MockReplayable replayableOther2 = new MockReplayable(replayableReplayOther2, replaybleTargetOther2);
		List<MockReplayable> replaySequenceOther = new LinkedList<MockReplayable>();
		replaySequenceOther.add(replayableOther1);
		replaySequenceOther.add(replayableOther2);
		ReplayableEvent<MockReplayable> other = new ReplayableEvent<MockReplayable>(
				typeOther);
		other.replayEvents = replaySequenceOther;
		other.replayValid = replayValidOther;

		boolean result = fixture.equals(other);

		assertEquals(false, result);
	}
	
	@Test
	public void testEquals_3() throws Exception {
		String type = "typeString";
		boolean replayValid = true;
		String replayableReplay1 = "replayString1";
		String replayableReplay2 = "replayString2";
		String replayableTarget1 = "replayTargetString1";
		String replayableTarget2 = "replayTargetString2";
		MockReplayable replayable1 = new MockReplayable(replayableReplay1,
				replayableTarget1);
		MockReplayable replayable2 = new MockReplayable(replayableReplay2, replayableTarget2);
		List<MockReplayable> replaySequence = new LinkedList<MockReplayable>();
		replaySequence.add(replayable1);
		replaySequence.add(replayable2);
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		fixture.replayEvents = replaySequence;
		fixture.replayValid = replayValid;
		
		String typeOther = "typeString";
		boolean replayValidOther = true;
		String replayableReplayOther1 = "replayString3";
		String replayableReplayOther2 = "replayString2";
		String replaybleTargetOther1 = "replayTargetString1";
		String replaybleTargetOther2 = "replayTargetString2";
		MockReplayable replayableOther1 = new MockReplayable(replayableReplayOther1,
				replaybleTargetOther1);
		MockReplayable replayableOther2 = new MockReplayable(replayableReplayOther2, replaybleTargetOther2);
		List<MockReplayable> replaySequenceOther = new LinkedList<MockReplayable>();
		replaySequenceOther.add(replayableOther1);
		replaySequenceOther.add(replayableOther2);
		ReplayableEvent<MockReplayable> other = new ReplayableEvent<MockReplayable>(
				typeOther);
		other.replayEvents = replaySequenceOther;
		other.replayValid = replayValidOther;

		boolean result = fixture.equals(other);

		assertEquals(false, result);
	}
	
	@Test
	public void testEquals_4() throws Exception {
		String type = "typeString";
		boolean replayValid = true;
		String replayableReplay1 = "replayString1";
		String replayableReplay2 = "replayString2";
		String replayableTarget1 = "replayTargetString1";
		String replayableTarget2 = "replayTargetString2";
		MockReplayable replayable1 = new MockReplayable(replayableReplay1,
				replayableTarget1);
		MockReplayable replayable2 = new MockReplayable(replayableReplay2, replayableTarget2);
		List<MockReplayable> replaySequence = new LinkedList<MockReplayable>();
		replaySequence.add(replayable1);
		replaySequence.add(replayable2);
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		fixture.replayEvents = replaySequence;
		fixture.replayValid = replayValid;
		
		String typeOther = "typeString";
		boolean replayValidOther = true;
		String replayableReplayOther1 = "replayString1";
		String replayableReplayOther2 = "replayString3";
		String replaybleTargetOther1 = "replayTargetString1";
		String replaybleTargetOther2 = "replayTargetString2";
		MockReplayable replayableOther1 = new MockReplayable(replayableReplayOther1,
				replaybleTargetOther1);
		MockReplayable replayableOther2 = new MockReplayable(replayableReplayOther2, replaybleTargetOther2);
		List<MockReplayable> replaySequenceOther = new LinkedList<MockReplayable>();
		replaySequenceOther.add(replayableOther1);
		replaySequenceOther.add(replayableOther2);
		ReplayableEvent<MockReplayable> other = new ReplayableEvent<MockReplayable>(
				typeOther);
		other.replayEvents = replaySequenceOther;
		other.replayValid = replayValidOther;

		boolean result = fixture.equals(other);

		assertEquals(false, result);
	}
	
	@Test
	public void testEquals_5() throws Exception {
		String type = "typeString";
		boolean replayValid = true;
		String replayableReplay1 = "replayString1";
		String replayableReplay2 = "replayString2";
		String replayableTarget1 = "replayTargetString1";
		String replayableTarget2 = "replayTargetString2";
		MockReplayable replayable1 = new MockReplayable(replayableReplay1,
				replayableTarget1);
		MockReplayable replayable2 = new MockReplayable(replayableReplay2, replayableTarget2);
		List<MockReplayable> replaySequence = new LinkedList<MockReplayable>();
		replaySequence.add(replayable1);
		replaySequence.add(replayable2);
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		fixture.replayEvents = replaySequence;
		fixture.replayValid = replayValid;
		
		String typeOther = "typeString";
		boolean replayValidOther = false;
		String replayableReplayOther1 = "replayString1";
		String replayableReplayOther2 = "replayString2";
		String replaybleTargetOther1 = "replayTargetString1";
		String replaybleTargetOther2 = "replayTargetString2";
		MockReplayable replayableOther1 = new MockReplayable(replayableReplayOther1,
				replaybleTargetOther1);
		MockReplayable replayableOther2 = new MockReplayable(replayableReplayOther2, replaybleTargetOther2);
		List<MockReplayable> replaySequenceOther = new LinkedList<MockReplayable>();
		replaySequenceOther.add(replayableOther1);
		replaySequenceOther.add(replayableOther2);
		ReplayableEvent<MockReplayable> other = new ReplayableEvent<MockReplayable>(
				typeOther);
		other.replayEvents = replaySequenceOther;
		other.replayValid = replayValidOther;

		boolean result = fixture.equals(other);

		assertEquals(false, result);
	}
	
	@Test
	public void testEquals_6() throws Exception {
		String type = "typeString";
		boolean replayValid = true;
		String replayableReplay1 = "replayString1";
		String replayableReplay2 = "replayString2";
		String replayableTarget1 = "replayTargetString1";
		String replayableTarget2 = "replayTargetString2";
		MockReplayable replayable1 = new MockReplayable(replayableReplay1,
				replayableTarget1);
		MockReplayable replayable2 = new MockReplayable(replayableReplay2, replayableTarget2);
		List<MockReplayable> replaySequence = new LinkedList<MockReplayable>();
		replaySequence.add(replayable1);
		replaySequence.add(replayable2);
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		fixture.replayEvents = replaySequence;
		fixture.replayValid = replayValid;

		boolean result = fixture.equals(fixture);

		assertEquals(true, result);
	}
	
	@Test 
	public void testEqualsContract() throws Exception {
		EqualsVerifier.forClass(ReplayableEvent.class)
		.suppress(Warning.STRICT_INHERITANCE, Warning.NONFINAL_FIELDS).withRedefinedSuperclass()
		.verify();
	}

	@Test
	public void testGetReplayDecorator_1() throws Exception {
		String type = "typeString";
		StubReplayDecorator decorator = new StubReplayDecorator();
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		fixture.decorator = decorator; 

		IReplayDecorator result = fixture.getReplayDecorator();

		assertEquals(decorator, result);
	}

	@Test
	public void testGetReplayMessages_1() throws Exception {
		String type = "typeString";
		String replayableReplay1 = "replayString1";
		String replayableReplay2 = "replayString2";
		String replayableTarget1 = "replayTargetString1";
		String replayableTarget2 = "replayTargetString2";
		MockReplayable replayable1 = new MockReplayable(replayableReplay1,
				replayableTarget1);
		MockReplayable replayable2 = new MockReplayable(replayableReplay2, replayableTarget2);
		List<MockReplayable> replaySequence = new LinkedList<MockReplayable>();
		replaySequence.add(replayable1);
		replaySequence.add(replayable2);
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		fixture.replayEvents = replaySequence;

		List<MockReplayable> result = fixture.getReplayMessages();

		ListAssert.assertEquals(replaySequence, result);
	}

	@Test
	public void testHasValidReplay_1() throws Exception {
		String type = "typeString";
		boolean replayValid = true;
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		fixture.replayValid = replayValid;

		boolean result = fixture.hasValidReplay();

		assertEquals(replayValid, result);
	}
	
	@Test
	public void testHasValidReplay_2() throws Exception {
		String type = "typeString";
		boolean replayValid = false;
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		fixture.replayValid = replayValid;

		boolean result = fixture.hasValidReplay();

		assertEquals(replayValid, result);
	}

	@Test
	public void testInvalidateReplay_1() throws Exception {
		String type = "typeString";
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		
		fixture.invalidateReplay();

		assertFalse(fixture.replayValid);
	}
	
	@Test
	public void testInvalidateReplay_2() throws Exception {
		String type = "typeString";
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);
		
		fixture.invalidateReplay();
		fixture.invalidateReplay();

		assertFalse(fixture.replayValid);
	}

	@Test
	public void testSetDecorator_fixture_1() throws Exception {
		String type = "typeString";
		StubReplayDecorator decorator = new StubReplayDecorator();
		ReplayableEvent<MockReplayable> fixture = new ReplayableEvent<MockReplayable>(
				type);

		fixture.setDecorator(decorator);

		assertEquals(decorator, fixture.decorator);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(ReplayableEventTest.class);
	}
}