/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Fog;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LinearFogRetained;
import javax.media.j3d.Node;
import javax.vecmath.Color3f;

public class LinearFog
extends Fog {
    public static final int ALLOW_DISTANCE_READ = 16;
    public static final int ALLOW_DISTANCE_WRITE = 17;

    public LinearFog() {
    }

    public LinearFog(Color3f color3f) {
        super(color3f);
    }

    public LinearFog(Color3f color3f, double d, double d2) {
        super(color3f);
        ((LinearFogRetained)this.retained).initFrontDistance(d);
        ((LinearFogRetained)this.retained).initBackDistance(d2);
    }

    public LinearFog(float f, float f2, float f3) {
        super(f, f2, f3);
    }

    public LinearFog(float f, float f2, float f3, double d, double d2) {
        super(f, f2, f3);
        ((LinearFogRetained)this.retained).initFrontDistance(d);
        ((LinearFogRetained)this.retained).initBackDistance(d2);
    }

    public void setFrontDistance(double d) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LinearFog0"));
        }
        if (this.isLive()) {
            ((LinearFogRetained)this.retained).setFrontDistance(d);
        } else {
            ((LinearFogRetained)this.retained).initFrontDistance(d);
        }
    }

    public double getFrontDistance() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LinearFog1"));
        }
        return ((LinearFogRetained)this.retained).getFrontDistance();
    }

    public void setBackDistance(double d) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LinearFog0"));
        }
        if (this.isLive()) {
            ((LinearFogRetained)this.retained).setBackDistance(d);
        } else {
            ((LinearFogRetained)this.retained).initBackDistance(d);
        }
    }

    public double getBackDistance() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LinearFog1"));
        }
        return ((LinearFogRetained)this.retained).getBackDistance();
    }

    void createRetained() {
        this.retained = new LinearFogRetained();
        this.retained.setSource(this);
    }

    public Node cloneNode(boolean bl) {
        LinearFog linearFog = new LinearFog();
        linearFog.duplicateNode(this, bl);
        return linearFog;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        LinearFogRetained linearFogRetained = (LinearFogRetained)node.retained;
        LinearFogRetained linearFogRetained2 = (LinearFogRetained)this.retained;
        linearFogRetained2.initFrontDistance(linearFogRetained.getFrontDistance());
        linearFogRetained2.initBackDistance(linearFogRetained.getBackDistance());
    }
}

