package de.ugoe.cs.eventbench.commands;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.security.InvalidParameterException;
import java.util.List;

import javax.swing.JFrame;

import org.apache.commons.collections15.Transformer;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.models.Trie.Edge;
import de.ugoe.cs.eventbench.models.Trie.TrieVertex;
import de.ugoe.cs.eventbench.models.TrieBasedModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.Renderer.VertexLabel.Position;

public class CMDshowTrie implements Command {

	@Override
	public void help() {
		Console.println("Usage: showTrie <modelName>");
	}
	
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		try {
			modelname = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		Object dataObject = GlobalDataContainer.getInstance().getData(modelname);
		if( dataObject==null ) {
			Console.printerrln("No model with name " + modelname + "found");
		} else {
			TrieBasedModel model = (TrieBasedModel) dataObject;
			Tree<TrieVertex, Edge> graph = model.getTrieGraph();
			Layout<TrieVertex, Edge> layout = new TreeLayout<TrieVertex, Edge>(graph, 60);
			// The BasicVisualizationServer<V,E> is parameterized by the edge types
			BasicVisualizationServer<TrieVertex,Edge> vv =
			new BasicVisualizationServer<TrieVertex,Edge>(layout);
			vv.setPreferredSize(new Dimension(1100,850)); //Sets the viewing area size
			
			
			final Rectangle rect = new Rectangle(40, 20);
				
			Transformer<TrieVertex, Shape> vertexShapeTransformer =
				new Transformer<TrieVertex, Shape>() {
					public Shape transform(TrieVertex s) {
						return rect;
					}
			};
			vv.getRenderer().getVertexLabelRenderer().setPosition(Position.CNTR);
			vv.getRenderContext().setVertexShapeTransformer(vertexShapeTransformer);
			vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller<TrieVertex>());
			
			JFrame frame = new JFrame("Trie");
			frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
			frame.getContentPane().add(vv);
			frame.pack();
			frame.setVisible(true);
		}
	}



}
