package de.ugoe.cs.eventbench.web.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.web.WeblogParser;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDloadSessionsFromClickstream implements Command {

	@Override
	public void run(List<Object> parameters) {
		// TODO Auto-generated method stub
		if( parameters.size() < 1 ) {
			throw new InvalidParameterException();
		}
		String source = (String) parameters.get(0);
		
		WeblogParser parser = new WeblogParser();
		try {
			parser.parseFile(source);
		} catch (FileNotFoundException e) {
			Console.println(e.getMessage());
		} catch (IOException e) {
			Console.println(e.getMessage());
		} catch (ParseException e) {
			Console.println("Invalid format of date stamps.");
			Console.println(e.getMessage());
		}
		
		GlobalDataContainer.getInstance().addData("sequences", parser.getSequences());
	}
	
	@Override
	public void help() {
		// TODO Auto-generated method stub
		
	}

}
