package de.ugoe.cs.eventbench.windows;

import de.ugoe.cs.eventbench.windows.data.WindowTree;
import de.ugoe.cs.eventbench.windows.data.WindowTreeNode;

public class HandlerSetText extends MessageHandler {

	public HandlerSetText() {
		super();
	}

	private String windowName;
	private int hwnd;

	@Override
	public void onEndElement() {
		if (hwnd != 0) {
			WindowTreeNode node = WindowTree.getInstance().find(hwnd);
			node.setName(windowName);
		}
	}

	@Override
	public void onParameter(String name, String value) {
		if (name.equals("window.hwnd")) {
			hwnd = Integer.parseInt(value);
		} else if (name.equals("window.newText")) {
			windowName = value;
		}
	}

	@Override
	public void onStartElement() {
		windowName = "";
		hwnd = 0;
	}
}
