/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.GVector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.MismatchedSizeException;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.VecMathI18N;

public class GMatrix
implements Serializable,
Cloneable {
    static final long serialVersionUID = 2777097312029690941L;
    private static final boolean debug = false;
    int nRow;
    int nCol;
    double[][] values;
    private static final double EPS = 1.0E-10;

    public GMatrix(int n, int n2) {
        this.values = new double[n][n2];
        this.nRow = n;
        this.nCol = n2;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.values[n3][n4] = 0.0;
                ++n4;
            }
            ++n3;
        }
        int n5 = n < n2 ? n : n2;
        n3 = 0;
        while (n3 < n5) {
            this.values[n3][n3] = 1.0;
            ++n3;
        }
    }

    public GMatrix(int n, int n2, double[] dArray) {
        this.values = new double[n][n2];
        this.nRow = n;
        this.nCol = n2;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.values[n3][n4] = dArray[n3 * n2 + n4];
                ++n4;
            }
            ++n3;
        }
    }

    public GMatrix(GMatrix gMatrix) {
        this.nRow = gMatrix.nRow;
        this.nCol = gMatrix.nCol;
        this.values = new double[this.nRow][this.nCol];
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                this.values[n][n2] = gMatrix.values[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public final void mul(GMatrix gMatrix) {
        if (this.nCol != gMatrix.nRow || this.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix0"));
        }
        double[][] dArray = new double[this.nRow][this.nCol];
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                dArray[n][n2] = 0.0;
                int n3 = 0;
                while (n3 < this.nCol) {
                    double[] dArray2 = dArray[n];
                    int n4 = n2;
                    dArray2[n4] = dArray2[n4] + this.values[n][n3] * gMatrix.values[n3][n2];
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.values = dArray;
    }

    public final void mul(GMatrix gMatrix, GMatrix gMatrix2) {
        if (gMatrix.nCol != gMatrix2.nRow || this.nRow != gMatrix.nRow || this.nCol != gMatrix2.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix1"));
        }
        double[][] dArray = new double[this.nRow][this.nCol];
        int n = 0;
        while (n < gMatrix.nRow) {
            int n2 = 0;
            while (n2 < gMatrix2.nCol) {
                dArray[n][n2] = 0.0;
                int n3 = 0;
                while (n3 < gMatrix.nCol) {
                    double[] dArray2 = dArray[n];
                    int n4 = n2;
                    dArray2[n4] = dArray2[n4] + gMatrix.values[n][n3] * gMatrix2.values[n3][n2];
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.values = dArray;
    }

    public final void mul(GVector gVector, GVector gVector2) {
        if (this.nRow < gVector.getSize()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix2"));
        }
        if (this.nCol < gVector2.getSize()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix3"));
        }
        int n = 0;
        while (n < gVector.getSize()) {
            int n2 = 0;
            while (n2 < gVector2.getSize()) {
                this.values[n][n2] = gVector.values[n] * gVector2.values[n2];
                ++n2;
            }
            ++n;
        }
    }

    public final void add(GMatrix gMatrix) {
        if (this.nRow != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix4"));
        }
        if (this.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix5"));
        }
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                this.values[n][n2] = this.values[n][n2] + gMatrix.values[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public final void add(GMatrix gMatrix, GMatrix gMatrix2) {
        if (gMatrix2.nRow != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix6"));
        }
        if (gMatrix2.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix7"));
        }
        if (this.nCol != gMatrix.nCol || this.nRow != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix8"));
        }
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                this.values[n][n2] = gMatrix.values[n][n2] + gMatrix2.values[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public final void sub(GMatrix gMatrix) {
        if (this.nRow != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix9"));
        }
        if (this.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix28"));
        }
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                this.values[n][n2] = this.values[n][n2] - gMatrix.values[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public final void sub(GMatrix gMatrix, GMatrix gMatrix2) {
        if (gMatrix2.nRow != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix10"));
        }
        if (gMatrix2.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix11"));
        }
        if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix12"));
        }
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                this.values[n][n2] = gMatrix.values[n][n2] - gMatrix2.values[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public final void negate() {
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                this.values[n][n2] = -this.values[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public final void negate(GMatrix gMatrix) {
        if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix13"));
        }
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                this.values[n][n2] = -gMatrix.values[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public final void setIdentity() {
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                this.values[n][n2] = 0.0;
                ++n2;
            }
            ++n;
        }
        int n3 = this.nRow < this.nCol ? this.nRow : this.nCol;
        n = 0;
        while (n < n3) {
            this.values[n][n] = 1.0;
            ++n;
        }
    }

    public final void setZero() {
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                this.values[n][n2] = 0.0;
                ++n2;
            }
            ++n;
        }
    }

    public final void identityMinus() {
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                this.values[n][n2] = -this.values[n][n2];
                ++n2;
            }
            ++n;
        }
        int n3 = this.nRow < this.nCol ? this.nRow : this.nCol;
        n = 0;
        while (n < n3) {
            double[] dArray = this.values[n];
            int n4 = n++;
            dArray[n4] = dArray[n4] + 1.0;
        }
    }

    public final void invert() {
        this.invertGeneral(this);
    }

    public final void invert(GMatrix gMatrix) {
        this.invertGeneral(gMatrix);
    }

    public final void copySubMatrix(int n, int n2, int n3, int n4, int n5, int n6, GMatrix gMatrix) {
        if (this != gMatrix) {
            int n7 = 0;
            while (n7 < n3) {
                int n8 = 0;
                while (n8 < n4) {
                    gMatrix.values[n5 + n7][n6 + n8] = this.values[n + n7][n2 + n8];
                    ++n8;
                }
                ++n7;
            }
        } else {
            int n9;
            double[][] dArray = new double[n3][n4];
            int n10 = 0;
            while (n10 < n3) {
                n9 = 0;
                while (n9 < n4) {
                    dArray[n10][n9] = this.values[n + n10][n2 + n9];
                    ++n9;
                }
                ++n10;
            }
            n10 = 0;
            while (n10 < n3) {
                n9 = 0;
                while (n9 < n4) {
                    gMatrix.values[n5 + n10][n6 + n9] = dArray[n10][n9];
                    ++n9;
                }
                ++n10;
            }
        }
    }

    public final void setSize(int n, int n2) {
        double[][] dArray = new double[n][n2];
        int n3 = this.nRow < n ? this.nRow : n;
        int n4 = this.nCol < n2 ? this.nCol : n2;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n4) {
                dArray[n5][n6] = this.values[n5][n6];
                ++n6;
            }
            ++n5;
        }
        this.nRow = n;
        this.nCol = n2;
        this.values = dArray;
    }

    public final void set(double[] dArray) {
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                this.values[n][n2] = dArray[this.nCol * n + n2];
                ++n2;
            }
            ++n;
        }
    }

    public final void set(Matrix3f matrix3f) {
        if (this.nCol < 3 || this.nRow < 3) {
            this.nCol = 3;
            this.nRow = 3;
            this.values = new double[this.nRow][this.nCol];
        }
        this.values[0][0] = matrix3f.m00;
        this.values[0][1] = matrix3f.m01;
        this.values[0][2] = matrix3f.m02;
        this.values[1][0] = matrix3f.m10;
        this.values[1][1] = matrix3f.m11;
        this.values[1][2] = matrix3f.m12;
        this.values[2][0] = matrix3f.m20;
        this.values[2][1] = matrix3f.m21;
        this.values[2][2] = matrix3f.m22;
        int n = 3;
        while (n < this.nRow) {
            int n2 = 3;
            while (n2 < this.nCol) {
                this.values[n][n2] = 0.0;
                ++n2;
            }
            ++n;
        }
    }

    public final void set(Matrix3d matrix3d) {
        if (this.nRow < 3 || this.nCol < 3) {
            this.values = new double[3][3];
            this.nRow = 3;
            this.nCol = 3;
        }
        this.values[0][0] = matrix3d.m00;
        this.values[0][1] = matrix3d.m01;
        this.values[0][2] = matrix3d.m02;
        this.values[1][0] = matrix3d.m10;
        this.values[1][1] = matrix3d.m11;
        this.values[1][2] = matrix3d.m12;
        this.values[2][0] = matrix3d.m20;
        this.values[2][1] = matrix3d.m21;
        this.values[2][2] = matrix3d.m22;
        int n = 3;
        while (n < this.nRow) {
            int n2 = 3;
            while (n2 < this.nCol) {
                this.values[n][n2] = 0.0;
                ++n2;
            }
            ++n;
        }
    }

    public final void set(Matrix4f matrix4f) {
        if (this.nRow < 4 || this.nCol < 4) {
            this.values = new double[4][4];
            this.nRow = 4;
            this.nCol = 4;
        }
        this.values[0][0] = matrix4f.m00;
        this.values[0][1] = matrix4f.m01;
        this.values[0][2] = matrix4f.m02;
        this.values[0][3] = matrix4f.m03;
        this.values[1][0] = matrix4f.m10;
        this.values[1][1] = matrix4f.m11;
        this.values[1][2] = matrix4f.m12;
        this.values[1][3] = matrix4f.m13;
        this.values[2][0] = matrix4f.m20;
        this.values[2][1] = matrix4f.m21;
        this.values[2][2] = matrix4f.m22;
        this.values[2][3] = matrix4f.m23;
        this.values[3][0] = matrix4f.m30;
        this.values[3][1] = matrix4f.m31;
        this.values[3][2] = matrix4f.m32;
        this.values[3][3] = matrix4f.m33;
        int n = 4;
        while (n < this.nRow) {
            int n2 = 4;
            while (n2 < this.nCol) {
                this.values[n][n2] = 0.0;
                ++n2;
            }
            ++n;
        }
    }

    public final void set(Matrix4d matrix4d) {
        if (this.nRow < 4 || this.nCol < 4) {
            this.values = new double[4][4];
            this.nRow = 4;
            this.nCol = 4;
        }
        this.values[0][0] = matrix4d.m00;
        this.values[0][1] = matrix4d.m01;
        this.values[0][2] = matrix4d.m02;
        this.values[0][3] = matrix4d.m03;
        this.values[1][0] = matrix4d.m10;
        this.values[1][1] = matrix4d.m11;
        this.values[1][2] = matrix4d.m12;
        this.values[1][3] = matrix4d.m13;
        this.values[2][0] = matrix4d.m20;
        this.values[2][1] = matrix4d.m21;
        this.values[2][2] = matrix4d.m22;
        this.values[2][3] = matrix4d.m23;
        this.values[3][0] = matrix4d.m30;
        this.values[3][1] = matrix4d.m31;
        this.values[3][2] = matrix4d.m32;
        this.values[3][3] = matrix4d.m33;
        int n = 4;
        while (n < this.nRow) {
            int n2 = 4;
            while (n2 < this.nCol) {
                this.values[n][n2] = 0.0;
                ++n2;
            }
            ++n;
        }
    }

    public final void set(GMatrix gMatrix) {
        int n;
        if (this.nRow < gMatrix.nRow || this.nCol < gMatrix.nCol) {
            this.nRow = gMatrix.nRow;
            this.nCol = gMatrix.nCol;
            this.values = new double[this.nRow][this.nCol];
        }
        int n2 = 0;
        while (n2 < Math.min(this.nRow, gMatrix.nRow)) {
            n = 0;
            while (n < Math.min(this.nCol, gMatrix.nCol)) {
                this.values[n2][n] = gMatrix.values[n2][n];
                ++n;
            }
            ++n2;
        }
        n2 = gMatrix.nRow;
        while (n2 < this.nRow) {
            n = gMatrix.nCol;
            while (n < this.nCol) {
                this.values[n2][n] = 0.0;
                ++n;
            }
            ++n2;
        }
    }

    public final int getNumRow() {
        return this.nRow;
    }

    public final int getNumCol() {
        return this.nCol;
    }

    public final double getElement(int n, int n2) {
        return this.values[n][n2];
    }

    public final void setElement(int n, int n2, double d) {
        this.values[n][n2] = d;
    }

    public final void getRow(int n, double[] dArray) {
        int n2 = 0;
        while (n2 < this.nCol) {
            dArray[n2] = this.values[n][n2];
            ++n2;
        }
    }

    public final void getRow(int n, GVector gVector) {
        if (gVector.getSize() < this.nCol) {
            gVector.setSize(this.nCol);
        }
        int n2 = 0;
        while (n2 < this.nCol) {
            gVector.values[n2] = this.values[n][n2];
            ++n2;
        }
    }

    public final void getColumn(int n, double[] dArray) {
        int n2 = 0;
        while (n2 < this.nRow) {
            dArray[n2] = this.values[n2][n];
            ++n2;
        }
    }

    public final void getColumn(int n, GVector gVector) {
        if (gVector.getSize() < this.nRow) {
            gVector.setSize(this.nRow);
        }
        int n2 = 0;
        while (n2 < this.nRow) {
            gVector.values[n2] = this.values[n2][n];
            ++n2;
        }
    }

    public final void get(Matrix3d matrix3d) {
        if (this.nRow < 3 || this.nCol < 3) {
            matrix3d.setZero();
            if (this.nCol > 0) {
                if (this.nRow > 0) {
                    matrix3d.m00 = this.values[0][0];
                    if (this.nRow > 1) {
                        matrix3d.m10 = this.values[1][0];
                        if (this.nRow > 2) {
                            matrix3d.m20 = this.values[2][0];
                        }
                    }
                }
                if (this.nCol > 1) {
                    if (this.nRow > 0) {
                        matrix3d.m01 = this.values[0][1];
                        if (this.nRow > 1) {
                            matrix3d.m11 = this.values[1][1];
                            if (this.nRow > 2) {
                                matrix3d.m21 = this.values[2][1];
                            }
                        }
                    }
                    if (this.nCol > 2 && this.nRow > 0) {
                        matrix3d.m02 = this.values[0][2];
                        if (this.nRow > 1) {
                            matrix3d.m12 = this.values[1][2];
                            if (this.nRow > 2) {
                                matrix3d.m22 = this.values[2][2];
                            }
                        }
                    }
                }
            }
        } else {
            matrix3d.m00 = this.values[0][0];
            matrix3d.m01 = this.values[0][1];
            matrix3d.m02 = this.values[0][2];
            matrix3d.m10 = this.values[1][0];
            matrix3d.m11 = this.values[1][1];
            matrix3d.m12 = this.values[1][2];
            matrix3d.m20 = this.values[2][0];
            matrix3d.m21 = this.values[2][1];
            matrix3d.m22 = this.values[2][2];
        }
    }

    public final void get(Matrix3f matrix3f) {
        if (this.nRow < 3 || this.nCol < 3) {
            matrix3f.setZero();
            if (this.nCol > 0) {
                if (this.nRow > 0) {
                    matrix3f.m00 = (float)this.values[0][0];
                    if (this.nRow > 1) {
                        matrix3f.m10 = (float)this.values[1][0];
                        if (this.nRow > 2) {
                            matrix3f.m20 = (float)this.values[2][0];
                        }
                    }
                }
                if (this.nCol > 1) {
                    if (this.nRow > 0) {
                        matrix3f.m01 = (float)this.values[0][1];
                        if (this.nRow > 1) {
                            matrix3f.m11 = (float)this.values[1][1];
                            if (this.nRow > 2) {
                                matrix3f.m21 = (float)this.values[2][1];
                            }
                        }
                    }
                    if (this.nCol > 2 && this.nRow > 0) {
                        matrix3f.m02 = (float)this.values[0][2];
                        if (this.nRow > 1) {
                            matrix3f.m12 = (float)this.values[1][2];
                            if (this.nRow > 2) {
                                matrix3f.m22 = (float)this.values[2][2];
                            }
                        }
                    }
                }
            }
        } else {
            matrix3f.m00 = (float)this.values[0][0];
            matrix3f.m01 = (float)this.values[0][1];
            matrix3f.m02 = (float)this.values[0][2];
            matrix3f.m10 = (float)this.values[1][0];
            matrix3f.m11 = (float)this.values[1][1];
            matrix3f.m12 = (float)this.values[1][2];
            matrix3f.m20 = (float)this.values[2][0];
            matrix3f.m21 = (float)this.values[2][1];
            matrix3f.m22 = (float)this.values[2][2];
        }
    }

    public final void get(Matrix4d matrix4d) {
        if (this.nRow < 4 || this.nCol < 4) {
            matrix4d.setZero();
            if (this.nCol > 0) {
                if (this.nRow > 0) {
                    matrix4d.m00 = this.values[0][0];
                    if (this.nRow > 1) {
                        matrix4d.m10 = this.values[1][0];
                        if (this.nRow > 2) {
                            matrix4d.m20 = this.values[2][0];
                            if (this.nRow > 3) {
                                matrix4d.m30 = this.values[3][0];
                            }
                        }
                    }
                }
                if (this.nCol > 1) {
                    if (this.nRow > 0) {
                        matrix4d.m01 = this.values[0][1];
                        if (this.nRow > 1) {
                            matrix4d.m11 = this.values[1][1];
                            if (this.nRow > 2) {
                                matrix4d.m21 = this.values[2][1];
                                if (this.nRow > 3) {
                                    matrix4d.m31 = this.values[3][1];
                                }
                            }
                        }
                    }
                    if (this.nCol > 2) {
                        if (this.nRow > 0) {
                            matrix4d.m02 = this.values[0][2];
                            if (this.nRow > 1) {
                                matrix4d.m12 = this.values[1][2];
                                if (this.nRow > 2) {
                                    matrix4d.m22 = this.values[2][2];
                                    if (this.nRow > 3) {
                                        matrix4d.m32 = this.values[3][2];
                                    }
                                }
                            }
                        }
                        if (this.nCol > 3 && this.nRow > 0) {
                            matrix4d.m03 = this.values[0][3];
                            if (this.nRow > 1) {
                                matrix4d.m13 = this.values[1][3];
                                if (this.nRow > 2) {
                                    matrix4d.m23 = this.values[2][3];
                                    if (this.nRow > 3) {
                                        matrix4d.m33 = this.values[3][3];
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            matrix4d.m00 = this.values[0][0];
            matrix4d.m01 = this.values[0][1];
            matrix4d.m02 = this.values[0][2];
            matrix4d.m03 = this.values[0][3];
            matrix4d.m10 = this.values[1][0];
            matrix4d.m11 = this.values[1][1];
            matrix4d.m12 = this.values[1][2];
            matrix4d.m13 = this.values[1][3];
            matrix4d.m20 = this.values[2][0];
            matrix4d.m21 = this.values[2][1];
            matrix4d.m22 = this.values[2][2];
            matrix4d.m23 = this.values[2][3];
            matrix4d.m30 = this.values[3][0];
            matrix4d.m31 = this.values[3][1];
            matrix4d.m32 = this.values[3][2];
            matrix4d.m33 = this.values[3][3];
        }
    }

    public final void get(Matrix4f matrix4f) {
        if (this.nRow < 4 || this.nCol < 4) {
            matrix4f.setZero();
            if (this.nCol > 0) {
                if (this.nRow > 0) {
                    matrix4f.m00 = (float)this.values[0][0];
                    if (this.nRow > 1) {
                        matrix4f.m10 = (float)this.values[1][0];
                        if (this.nRow > 2) {
                            matrix4f.m20 = (float)this.values[2][0];
                            if (this.nRow > 3) {
                                matrix4f.m30 = (float)this.values[3][0];
                            }
                        }
                    }
                }
                if (this.nCol > 1) {
                    if (this.nRow > 0) {
                        matrix4f.m01 = (float)this.values[0][1];
                        if (this.nRow > 1) {
                            matrix4f.m11 = (float)this.values[1][1];
                            if (this.nRow > 2) {
                                matrix4f.m21 = (float)this.values[2][1];
                                if (this.nRow > 3) {
                                    matrix4f.m31 = (float)this.values[3][1];
                                }
                            }
                        }
                    }
                    if (this.nCol > 2) {
                        if (this.nRow > 0) {
                            matrix4f.m02 = (float)this.values[0][2];
                            if (this.nRow > 1) {
                                matrix4f.m12 = (float)this.values[1][2];
                                if (this.nRow > 2) {
                                    matrix4f.m22 = (float)this.values[2][2];
                                    if (this.nRow > 3) {
                                        matrix4f.m32 = (float)this.values[3][2];
                                    }
                                }
                            }
                        }
                        if (this.nCol > 3 && this.nRow > 0) {
                            matrix4f.m03 = (float)this.values[0][3];
                            if (this.nRow > 1) {
                                matrix4f.m13 = (float)this.values[1][3];
                                if (this.nRow > 2) {
                                    matrix4f.m23 = (float)this.values[2][3];
                                    if (this.nRow > 3) {
                                        matrix4f.m33 = (float)this.values[3][3];
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            matrix4f.m00 = (float)this.values[0][0];
            matrix4f.m01 = (float)this.values[0][1];
            matrix4f.m02 = (float)this.values[0][2];
            matrix4f.m03 = (float)this.values[0][3];
            matrix4f.m10 = (float)this.values[1][0];
            matrix4f.m11 = (float)this.values[1][1];
            matrix4f.m12 = (float)this.values[1][2];
            matrix4f.m13 = (float)this.values[1][3];
            matrix4f.m20 = (float)this.values[2][0];
            matrix4f.m21 = (float)this.values[2][1];
            matrix4f.m22 = (float)this.values[2][2];
            matrix4f.m23 = (float)this.values[2][3];
            matrix4f.m30 = (float)this.values[3][0];
            matrix4f.m31 = (float)this.values[3][1];
            matrix4f.m32 = (float)this.values[3][2];
            matrix4f.m33 = (float)this.values[3][3];
        }
    }

    public final void get(GMatrix gMatrix) {
        int n;
        int n2 = this.nCol < gMatrix.nCol ? this.nCol : gMatrix.nCol;
        int n3 = this.nRow < gMatrix.nRow ? this.nRow : gMatrix.nRow;
        int n4 = 0;
        while (n4 < n3) {
            n = 0;
            while (n < n2) {
                gMatrix.values[n4][n] = this.values[n4][n];
                ++n;
            }
            ++n4;
        }
        n4 = n3;
        while (n4 < gMatrix.nRow) {
            n = 0;
            while (n < gMatrix.nCol) {
                gMatrix.values[n4][n] = 0.0;
                ++n;
            }
            ++n4;
        }
        n = n2;
        while (n < gMatrix.nCol) {
            n4 = 0;
            while (n4 < n3) {
                gMatrix.values[n4][n] = 0.0;
                ++n4;
            }
            ++n;
        }
    }

    public final void setRow(int n, double[] dArray) {
        int n2 = 0;
        while (n2 < this.nCol) {
            this.values[n][n2] = dArray[n2];
            ++n2;
        }
    }

    public final void setRow(int n, GVector gVector) {
        int n2 = 0;
        while (n2 < this.nCol) {
            this.values[n][n2] = gVector.values[n2];
            ++n2;
        }
    }

    public final void setColumn(int n, double[] dArray) {
        int n2 = 0;
        while (n2 < this.nRow) {
            this.values[n2][n] = dArray[n2];
            ++n2;
        }
    }

    public final void setColumn(int n, GVector gVector) {
        int n2 = 0;
        while (n2 < this.nRow) {
            this.values[n2][n] = gVector.values[n2];
            ++n2;
        }
    }

    public final void mulTransposeBoth(GMatrix gMatrix, GMatrix gMatrix2) {
        if (gMatrix.nRow != gMatrix2.nCol || this.nRow != gMatrix.nCol || this.nCol != gMatrix2.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix14"));
        }
        if (gMatrix == this || gMatrix2 == this) {
            double[][] dArray = new double[this.nRow][this.nCol];
            int n = 0;
            while (n < this.nRow) {
                int n2 = 0;
                while (n2 < this.nCol) {
                    dArray[n][n2] = 0.0;
                    int n3 = 0;
                    while (n3 < gMatrix.nRow) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + gMatrix.values[n3][n] * gMatrix2.values[n2][n3];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            this.values = dArray;
        } else {
            int n = 0;
            while (n < this.nRow) {
                int n5 = 0;
                while (n5 < this.nCol) {
                    this.values[n][n5] = 0.0;
                    int n6 = 0;
                    while (n6 < gMatrix.nRow) {
                        double[] dArray = this.values[n];
                        int n7 = n5;
                        dArray[n7] = dArray[n7] + gMatrix.values[n6][n] * gMatrix2.values[n5][n6];
                        ++n6;
                    }
                    ++n5;
                }
                ++n;
            }
        }
    }

    public final void mulTransposeRight(GMatrix gMatrix, GMatrix gMatrix2) {
        if (gMatrix.nCol != gMatrix2.nCol || this.nCol != gMatrix2.nRow || this.nRow != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix15"));
        }
        if (gMatrix == this || gMatrix2 == this) {
            double[][] dArray = new double[this.nRow][this.nCol];
            int n = 0;
            while (n < this.nRow) {
                int n2 = 0;
                while (n2 < this.nCol) {
                    dArray[n][n2] = 0.0;
                    int n3 = 0;
                    while (n3 < gMatrix.nCol) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + gMatrix.values[n][n3] * gMatrix2.values[n2][n3];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            this.values = dArray;
        } else {
            int n = 0;
            while (n < this.nRow) {
                int n5 = 0;
                while (n5 < this.nCol) {
                    this.values[n][n5] = 0.0;
                    int n6 = 0;
                    while (n6 < gMatrix.nCol) {
                        double[] dArray = this.values[n];
                        int n7 = n5;
                        dArray[n7] = dArray[n7] + gMatrix.values[n][n6] * gMatrix2.values[n5][n6];
                        ++n6;
                    }
                    ++n5;
                }
                ++n;
            }
        }
    }

    public final void mulTransposeLeft(GMatrix gMatrix, GMatrix gMatrix2) {
        if (gMatrix.nRow != gMatrix2.nRow || this.nCol != gMatrix2.nCol || this.nRow != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix16"));
        }
        if (gMatrix == this || gMatrix2 == this) {
            double[][] dArray = new double[this.nRow][this.nCol];
            int n = 0;
            while (n < this.nRow) {
                int n2 = 0;
                while (n2 < this.nCol) {
                    dArray[n][n2] = 0.0;
                    int n3 = 0;
                    while (n3 < gMatrix.nRow) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + gMatrix.values[n3][n] * gMatrix2.values[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            this.values = dArray;
        } else {
            int n = 0;
            while (n < this.nRow) {
                int n5 = 0;
                while (n5 < this.nCol) {
                    this.values[n][n5] = 0.0;
                    int n6 = 0;
                    while (n6 < gMatrix.nRow) {
                        double[] dArray = this.values[n];
                        int n7 = n5;
                        dArray[n7] = dArray[n7] + gMatrix.values[n6][n] * gMatrix2.values[n6][n5];
                        ++n6;
                    }
                    ++n5;
                }
                ++n;
            }
        }
    }

    public final void transpose() {
        if (this.nRow != this.nCol) {
            int n = this.nRow;
            this.nRow = this.nCol;
            this.nCol = n;
            double[][] dArray = new double[this.nRow][this.nCol];
            n = 0;
            while (n < this.nRow) {
                int n2 = 0;
                while (n2 < this.nCol) {
                    dArray[n][n2] = this.values[n2][n];
                    ++n2;
                }
                ++n;
            }
            this.values = dArray;
        } else {
            int n = 0;
            while (n < this.nRow) {
                int n3 = 0;
                while (n3 < n) {
                    double d = this.values[n][n3];
                    this.values[n][n3] = this.values[n3][n];
                    this.values[n3][n] = d;
                    ++n3;
                }
                ++n;
            }
        }
    }

    public final void transpose(GMatrix gMatrix) {
        if (this.nRow != gMatrix.nCol || this.nCol != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix17"));
        }
        if (gMatrix != this) {
            int n = 0;
            while (n < this.nRow) {
                int n2 = 0;
                while (n2 < this.nCol) {
                    this.values[n][n2] = gMatrix.values[n2][n];
                    ++n2;
                }
                ++n;
            }
        } else {
            this.transpose();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.nRow * this.nCol * 8);
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                stringBuffer.append(this.values[n][n2]).append(" ");
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    private static void checkMatrix(GMatrix gMatrix) {
        int n = 0;
        while (n < gMatrix.nRow) {
            int n2 = 0;
            while (n2 < gMatrix.nCol) {
                if (Math.abs(gMatrix.values[n][n2]) < 1.0E-10) {
                    System.out.print(" 0.0     ");
                } else {
                    System.out.print(" " + gMatrix.values[n][n2]);
                }
                ++n2;
            }
            System.out.print("\n");
            ++n;
        }
    }

    public int hashCode() {
        long l = 1L;
        l = 31L * l + (long)this.nRow;
        l = 31L * l + (long)this.nCol;
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                l = 31L * l + Double.doubleToLongBits(this.values[n][n2]);
                ++n2;
            }
            ++n;
        }
        return (int)(l ^ l >> 32);
    }

    public boolean equals(GMatrix gMatrix) {
        try {
            if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
                return false;
            }
            int n = 0;
            while (n < this.nRow) {
                int n2 = 0;
                while (n2 < this.nCol) {
                    if (this.values[n][n2] != gMatrix.values[n][n2]) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        try {
            GMatrix gMatrix = (GMatrix)object;
            if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
                return false;
            }
            int n = 0;
            while (n < this.nRow) {
                int n2 = 0;
                while (n2 < this.nCol) {
                    if (this.values[n][n2] != gMatrix.values[n][n2]) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean epsilonEquals(GMatrix gMatrix, float f) {
        return this.epsilonEquals(gMatrix, (double)f);
    }

    public boolean epsilonEquals(GMatrix gMatrix, double d) {
        if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
            return false;
        }
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                double d2 = this.values[n][n2] - gMatrix.values[n][n2];
                double d3 = d2 < 0.0 ? -d2 : d2;
                if (d3 > d) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public final double trace() {
        int n = this.nRow < this.nCol ? this.nRow : this.nCol;
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += this.values[n2][n2];
            ++n2;
        }
        return d;
    }

    public final int SVD(GMatrix gMatrix, GMatrix gMatrix2, GMatrix gMatrix3) {
        if (this.nCol != gMatrix3.nCol || this.nCol != gMatrix3.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix18"));
        }
        if (this.nRow != gMatrix.nRow || this.nRow != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix25"));
        }
        if (this.nRow != gMatrix2.nRow || this.nCol != gMatrix2.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix26"));
        }
        if (this.nRow == 2 && this.nCol == 2 && this.values[1][0] == 0.0) {
            gMatrix.setIdentity();
            gMatrix3.setIdentity();
            if (this.values[0][1] == 0.0) {
                return 2;
            }
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            double[] dArray3 = new double[1];
            double[] dArray4 = new double[1];
            double[] dArray5 = new double[]{this.values[0][0], this.values[1][1]};
            GMatrix.compute_2X2(this.values[0][0], this.values[0][1], this.values[1][1], dArray5, dArray, dArray3, dArray2, dArray4, 0);
            GMatrix.update_u(0, gMatrix, dArray3, dArray);
            GMatrix.update_v(0, gMatrix3, dArray4, dArray2);
            return 2;
        }
        return GMatrix.computeSVD(this, gMatrix, gMatrix2, gMatrix3);
    }

    public final int LUD(GMatrix gMatrix, GVector gVector) {
        int n;
        int n2 = gMatrix.nRow * gMatrix.nCol;
        double[] dArray = new double[n2];
        int[] nArray = new int[1];
        int[] nArray2 = new int[gMatrix.nRow];
        if (this.nRow != this.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix19"));
        }
        if (this.nRow != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix27"));
        }
        if (this.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix27"));
        }
        if (gMatrix.nRow != gVector.getSize()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix20"));
        }
        int n3 = 0;
        while (n3 < this.nRow) {
            n = 0;
            while (n < this.nCol) {
                dArray[n3 * this.nCol + n] = this.values[n3][n];
                ++n;
            }
            ++n3;
        }
        if (!GMatrix.luDecomposition(gMatrix.nRow, dArray, nArray2, nArray)) {
            throw new SingularMatrixException(VecMathI18N.getString("GMatrix21"));
        }
        n3 = 0;
        while (n3 < this.nRow) {
            n = 0;
            while (n < this.nCol) {
                gMatrix.values[n3][n] = dArray[n3 * this.nCol + n];
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < gMatrix.nRow) {
            gVector.values[n3] = nArray2[n3];
            ++n3;
        }
        return nArray[0];
    }

    public final void setScale(double d) {
        int n = this.nRow < this.nCol ? this.nRow : this.nCol;
        int n2 = 0;
        while (n2 < this.nRow) {
            int n3 = 0;
            while (n3 < this.nCol) {
                this.values[n2][n3] = 0.0;
                ++n3;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            this.values[n2][n2] = d;
            ++n2;
        }
    }

    final void invertGeneral(GMatrix gMatrix) {
        int n;
        int n2 = gMatrix.nRow * gMatrix.nCol;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        int[] nArray = new int[gMatrix.nRow];
        int[] nArray2 = new int[1];
        if (gMatrix.nRow != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix22"));
        }
        int n3 = 0;
        while (n3 < this.nRow) {
            n = 0;
            while (n < this.nCol) {
                dArray[n3 * this.nCol + n] = gMatrix.values[n3][n];
                ++n;
            }
            ++n3;
        }
        if (!GMatrix.luDecomposition(gMatrix.nRow, dArray, nArray, nArray2)) {
            throw new SingularMatrixException(VecMathI18N.getString("GMatrix21"));
        }
        n3 = 0;
        while (n3 < n2) {
            dArray2[n3] = 0.0;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.nCol) {
            dArray2[n3 + n3 * this.nCol] = 1.0;
            ++n3;
        }
        GMatrix.luBacksubstitution(gMatrix.nRow, dArray, nArray, dArray2);
        n3 = 0;
        while (n3 < this.nRow) {
            n = 0;
            while (n < this.nCol) {
                this.values[n3][n] = dArray2[n3 * this.nCol + n];
                ++n;
            }
            ++n3;
        }
    }

    static boolean luDecomposition(int n, double[] dArray, int[] nArray, int[] nArray2) {
        double d;
        int n2;
        double d2;
        double[] dArray2 = new double[n];
        int n3 = 0;
        int n4 = 0;
        nArray2[0] = 1;
        int n5 = n;
        while (n5-- != 0) {
            d2 = 0.0;
            n2 = n;
            while (n2-- != 0) {
                d = dArray[n3++];
                if (!((d = Math.abs(d)) > d2)) continue;
                d2 = d;
            }
            if (d2 == 0.0) {
                return false;
            }
            dArray2[n4++] = 1.0 / d2;
        }
        int n6 = 0;
        n2 = 0;
        while (n2 < n) {
            int n7;
            int n8;
            int n9;
            double d3;
            int n10;
            n5 = 0;
            while (n5 < n2) {
                n10 = n6 + n * n5 + n2;
                d3 = dArray[n10];
                n9 = n5;
                n8 = n6 + n * n5;
                n7 = n6 + n2;
                while (n9-- != 0) {
                    d3 -= dArray[n8] * dArray[n7];
                    ++n8;
                    n7 += n;
                }
                dArray[n10] = d3;
                ++n5;
            }
            d2 = 0.0;
            int n11 = -1;
            n5 = n2;
            while (n5 < n) {
                double d4;
                n10 = n6 + n * n5 + n2;
                d3 = dArray[n10];
                n9 = n2;
                n8 = n6 + n * n5;
                n7 = n6 + n2;
                while (n9-- != 0) {
                    d3 -= dArray[n8] * dArray[n7];
                    ++n8;
                    n7 += n;
                }
                dArray[n10] = d3;
                d = dArray2[n5] * Math.abs(d3);
                if (d4 >= d2) {
                    d2 = d;
                    n11 = n5;
                }
                ++n5;
            }
            if (n11 < 0) {
                throw new RuntimeException(VecMathI18N.getString("GMatrix24"));
            }
            if (n2 != n11) {
                n9 = n;
                n8 = n6 + n * n11;
                n7 = n6 + n * n2;
                while (n9-- != 0) {
                    d = dArray[n8];
                    dArray[n8++] = dArray[n7];
                    dArray[n7++] = d;
                }
                dArray2[n11] = dArray2[n2];
                nArray2[0] = -nArray2[0];
            }
            nArray[n2] = n11;
            if (dArray[n6 + n * n2 + n2] == 0.0) {
                return false;
            }
            if (n2 != n - 1) {
                d = 1.0 / dArray[n6 + n * n2 + n2];
                n10 = n6 + n * (n2 + 1) + n2;
                n5 = n - 1 - n2;
                while (n5-- != 0) {
                    int n12 = n10;
                    dArray[n12] = dArray[n12] * d;
                    n10 += n;
                }
            }
            ++n2;
        }
        return true;
    }

    static void luBacksubstitution(int n, double[] dArray, int[] nArray, double[] dArray2) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5;
            int n6 = n3;
            int n7 = -1;
            int n8 = 0;
            while (n8 < n) {
                int n9 = nArray[n2 + n8];
                double d = dArray2[n6 + n * n9];
                dArray2[n6 + n * n9] = dArray2[n6 + n * n8];
                if (n7 >= 0) {
                    n5 = n8 * n;
                    n4 = n7;
                    while (n4 <= n8 - 1) {
                        d -= dArray[n5 + n4] * dArray2[n6 + n * n4];
                        ++n4;
                    }
                } else if (d != 0.0) {
                    n7 = n8;
                }
                dArray2[n6 + n * n8] = d;
                ++n8;
            }
            n8 = 0;
            while (n8 < n) {
                int n10 = n - 1 - n8;
                n5 = n * n10;
                double d = 0.0;
                n4 = 1;
                while (n4 <= n8) {
                    d += dArray[n5 + n - n4] * dArray2[n6 + n * (n - n4)];
                    ++n4;
                }
                dArray2[n6 + n * n10] = (dArray2[n6 + n * n10] - d) / dArray[n5 + n10];
                ++n8;
            }
            ++n3;
        }
    }

    static int computeSVD(GMatrix gMatrix, GMatrix gMatrix2, GMatrix gMatrix3, GMatrix gMatrix4) {
        int n;
        int n2;
        int n3;
        GMatrix gMatrix5 = new GMatrix(gMatrix.nRow, gMatrix.nCol);
        GMatrix gMatrix6 = new GMatrix(gMatrix.nRow, gMatrix.nCol);
        GMatrix gMatrix7 = new GMatrix(gMatrix.nRow, gMatrix.nCol);
        GMatrix gMatrix8 = new GMatrix(gMatrix);
        if (gMatrix8.nRow >= gMatrix8.nCol) {
            n3 = gMatrix8.nCol;
            n2 = gMatrix8.nCol - 1;
        } else {
            n3 = gMatrix8.nRow;
            n2 = gMatrix8.nRow;
        }
        int n4 = gMatrix8.nRow > gMatrix8.nCol ? gMatrix8.nRow : gMatrix8.nCol;
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n2];
        int n5 = 0;
        gMatrix2.setIdentity();
        gMatrix4.setIdentity();
        int n6 = gMatrix8.nRow;
        int n7 = gMatrix8.nCol;
        int n8 = 0;
        while (n8 < n3) {
            double d;
            int n9;
            int n10;
            double d2;
            double d3;
            if (n6 > 1) {
                d3 = 0.0;
                n = 0;
                while (n < n6) {
                    d3 += gMatrix8.values[n + n8][n8] * gMatrix8.values[n + n8][n8];
                    ++n;
                }
                d3 = Math.sqrt(d3);
                dArray[0] = gMatrix8.values[n8][n8] == 0.0 ? d3 : gMatrix8.values[n8][n8] + GMatrix.d_sign(d3, gMatrix8.values[n8][n8]);
                n = 1;
                while (n < n6) {
                    dArray[n] = gMatrix8.values[n8 + n][n8];
                    ++n;
                }
                d2 = 0.0;
                n = 0;
                while (n < n6) {
                    d2 += dArray[n] * dArray[n];
                    ++n;
                }
                d2 = 2.0 / d2;
                n10 = n8;
                while (n10 < gMatrix8.nRow) {
                    n9 = n8;
                    while (n9 < gMatrix8.nRow) {
                        gMatrix6.values[n10][n9] = -d2 * dArray[n10 - n8] * dArray[n9 - n8];
                        ++n9;
                    }
                    ++n10;
                }
                n = n8;
                while (n < gMatrix8.nRow) {
                    double[] dArray4 = gMatrix6.values[n];
                    int n11 = n++;
                    dArray4[n11] = dArray4[n11] + 1.0;
                }
                d = 0.0;
                n = n8;
                while (n < gMatrix8.nRow) {
                    d += gMatrix6.values[n8][n] * gMatrix8.values[n][n8];
                    ++n;
                }
                gMatrix8.values[n8][n8] = d;
                n10 = n8;
                while (n10 < gMatrix8.nRow) {
                    n9 = n8 + 1;
                    while (n9 < gMatrix8.nCol) {
                        gMatrix5.values[n10][n9] = 0.0;
                        n = n8;
                        while (n < gMatrix8.nCol) {
                            double[] dArray5 = gMatrix5.values[n10];
                            int n12 = n9;
                            dArray5[n12] = dArray5[n12] + gMatrix6.values[n10][n] * gMatrix8.values[n][n9];
                            ++n;
                        }
                        ++n9;
                    }
                    ++n10;
                }
                n10 = n8;
                while (n10 < gMatrix8.nRow) {
                    n9 = n8 + 1;
                    while (n9 < gMatrix8.nCol) {
                        gMatrix8.values[n10][n9] = gMatrix5.values[n10][n9];
                        ++n9;
                    }
                    ++n10;
                }
                n10 = n8;
                while (n10 < gMatrix8.nRow) {
                    n9 = 0;
                    while (n9 < gMatrix8.nCol) {
                        gMatrix5.values[n10][n9] = 0.0;
                        n = n8;
                        while (n < gMatrix8.nCol) {
                            double[] dArray6 = gMatrix5.values[n10];
                            int n13 = n9;
                            dArray6[n13] = dArray6[n13] + gMatrix6.values[n10][n] * gMatrix2.values[n][n9];
                            ++n;
                        }
                        ++n9;
                    }
                    ++n10;
                }
                n10 = n8;
                while (n10 < gMatrix8.nRow) {
                    n9 = 0;
                    while (n9 < gMatrix8.nCol) {
                        gMatrix2.values[n10][n9] = gMatrix5.values[n10][n9];
                        ++n9;
                    }
                    ++n10;
                }
                --n6;
            }
            if (n7 > 2) {
                d3 = 0.0;
                n = 1;
                while (n < n7) {
                    d3 += gMatrix8.values[n8][n8 + n] * gMatrix8.values[n8][n8 + n];
                    ++n;
                }
                d3 = Math.sqrt(d3);
                dArray[0] = gMatrix8.values[n8][n8 + 1] == 0.0 ? d3 : gMatrix8.values[n8][n8 + 1] + GMatrix.d_sign(d3, gMatrix8.values[n8][n8 + 1]);
                n = 1;
                while (n < n7 - 1) {
                    dArray[n] = gMatrix8.values[n8][n8 + n + 1];
                    ++n;
                }
                d2 = 0.0;
                n = 0;
                while (n < n7 - 1) {
                    d2 += dArray[n] * dArray[n];
                    ++n;
                }
                d2 = 2.0 / d2;
                n10 = n8 + 1;
                while (n10 < n7) {
                    n9 = n8 + 1;
                    while (n9 < gMatrix8.nCol) {
                        gMatrix7.values[n10][n9] = -d2 * dArray[n10 - n8 - 1] * dArray[n9 - n8 - 1];
                        ++n9;
                    }
                    ++n10;
                }
                n = n8 + 1;
                while (n < gMatrix8.nCol) {
                    double[] dArray7 = gMatrix7.values[n];
                    int n14 = n++;
                    dArray7[n14] = dArray7[n14] + 1.0;
                }
                d = 0.0;
                n = n8;
                while (n < gMatrix8.nCol) {
                    d += gMatrix7.values[n][n8 + 1] * gMatrix8.values[n8][n];
                    ++n;
                }
                gMatrix8.values[n8][n8 + 1] = d;
                n10 = n8 + 1;
                while (n10 < gMatrix8.nRow) {
                    n9 = n8 + 1;
                    while (n9 < gMatrix8.nCol) {
                        gMatrix5.values[n10][n9] = 0.0;
                        n = n8 + 1;
                        while (n < gMatrix8.nCol) {
                            double[] dArray8 = gMatrix5.values[n10];
                            int n15 = n9;
                            dArray8[n15] = dArray8[n15] + gMatrix7.values[n][n9] * gMatrix8.values[n10][n];
                            ++n;
                        }
                        ++n9;
                    }
                    ++n10;
                }
                n10 = n8 + 1;
                while (n10 < gMatrix8.nRow) {
                    n9 = n8 + 1;
                    while (n9 < gMatrix8.nCol) {
                        gMatrix8.values[n10][n9] = gMatrix5.values[n10][n9];
                        ++n9;
                    }
                    ++n10;
                }
                n10 = 0;
                while (n10 < gMatrix8.nRow) {
                    n9 = n8 + 1;
                    while (n9 < gMatrix8.nCol) {
                        gMatrix5.values[n10][n9] = 0.0;
                        n = n8 + 1;
                        while (n < gMatrix8.nCol) {
                            double[] dArray9 = gMatrix5.values[n10];
                            int n16 = n9;
                            dArray9[n16] = dArray9[n16] + gMatrix7.values[n][n9] * gMatrix4.values[n10][n];
                            ++n;
                        }
                        ++n9;
                    }
                    ++n10;
                }
                n10 = 0;
                while (n10 < gMatrix8.nRow) {
                    n9 = n8 + 1;
                    while (n9 < gMatrix8.nCol) {
                        gMatrix4.values[n10][n9] = gMatrix5.values[n10][n9];
                        ++n9;
                    }
                    ++n10;
                }
                --n7;
            }
            ++n8;
        }
        n = 0;
        while (n < n3) {
            dArray2[n] = gMatrix8.values[n][n];
            ++n;
        }
        n = 0;
        while (n < n2) {
            dArray3[n] = gMatrix8.values[n][n + 1];
            ++n;
        }
        if (gMatrix8.nRow == 2 && gMatrix8.nCol == 2) {
            double[] dArray10 = new double[1];
            double[] dArray11 = new double[1];
            double[] dArray12 = new double[1];
            double[] dArray13 = new double[1];
            GMatrix.compute_2X2(dArray2[0], dArray3[0], dArray2[1], dArray2, dArray12, dArray10, dArray13, dArray11, 0);
            GMatrix.update_u(0, gMatrix2, dArray10, dArray12);
            GMatrix.update_v(0, gMatrix4, dArray11, dArray13);
            return 2;
        }
        GMatrix.compute_qr(0, dArray3.length - 1, dArray2, dArray3, gMatrix2, gMatrix4);
        n5 = dArray2.length;
        return n5;
    }

    static void compute_qr(int n, int n2, double[] dArray, double[] dArray2, GMatrix gMatrix, GMatrix gMatrix2) {
        int n3;
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        GMatrix gMatrix3 = new GMatrix(gMatrix.nCol, gMatrix2.nRow);
        double d = 1.0;
        double d2 = -1.0;
        boolean bl = false;
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = 0;
        while (n4 < 2 && !bl) {
            double d5;
            n3 = n;
            while (n3 <= n2) {
                if (n3 == n) {
                    int n5 = dArray2.length == dArray.length ? n2 : n2 + 1;
                    double d6 = GMatrix.compute_shift(dArray[n5 - 1], dArray2[n2], dArray[n5]);
                    d3 = (Math.abs(dArray[n3]) - d6) * (GMatrix.d_sign(d, dArray[n3]) + d6 / dArray[n3]);
                    d4 = dArray2[n3];
                }
                d5 = GMatrix.compute_rot(d3, d4, dArray6, dArray4);
                if (n3 != n) {
                    dArray2[n3 - 1] = d5;
                }
                d3 = dArray4[0] * dArray[n3] + dArray6[0] * dArray2[n3];
                dArray2[n3] = dArray4[0] * dArray2[n3] - dArray6[0] * dArray[n3];
                d4 = dArray6[0] * dArray[n3 + 1];
                dArray[n3 + 1] = dArray4[0] * dArray[n3 + 1];
                GMatrix.update_v(n3, gMatrix2, dArray4, dArray6);
                dArray[n3] = d5 = GMatrix.compute_rot(d3, d4, dArray5, dArray3);
                d3 = dArray3[0] * dArray2[n3] + dArray5[0] * dArray[n3 + 1];
                dArray[n3 + 1] = dArray3[0] * dArray[n3 + 1] - dArray5[0] * dArray2[n3];
                if (n3 < n2) {
                    d4 = dArray5[0] * dArray2[n3 + 1];
                    dArray2[n3 + 1] = dArray3[0] * dArray2[n3 + 1];
                }
                GMatrix.update_u(n3, gMatrix, dArray3, dArray5);
                ++n3;
            }
            if (dArray.length == dArray2.length) {
                d5 = GMatrix.compute_rot(d3, d4, dArray6, dArray4);
                d3 = dArray4[0] * dArray[n3] + dArray6[0] * dArray2[n3];
                dArray2[n3] = dArray4[0] * dArray2[n3] - dArray6[0] * dArray[n3];
                dArray[n3 + 1] = dArray4[0] * dArray[n3 + 1];
                GMatrix.update_v(n3, gMatrix2, dArray4, dArray6);
            }
            while (n2 - n > 1 && Math.abs(dArray2[n2]) < 4.89E-15) {
                --n2;
            }
            int n6 = n2 - 2;
            while (n6 > n) {
                if (Math.abs(dArray2[n6]) < 4.89E-15) {
                    GMatrix.compute_qr(n6 + 1, n2, dArray, dArray2, gMatrix, gMatrix2);
                    n2 = n6 - 1;
                    while (n2 - n > 1 && Math.abs(dArray2[n2]) < 4.89E-15) {
                        --n2;
                    }
                }
                --n6;
            }
            if (n2 - n <= 1 && Math.abs(dArray2[n + 1]) < 4.89E-15) {
                bl = true;
            }
            ++n4;
        }
        if (Math.abs(dArray2[1]) < 4.89E-15) {
            GMatrix.compute_2X2(dArray[n], dArray2[n], dArray[n + 1], dArray, dArray5, dArray3, dArray6, dArray4, 0);
            dArray2[n] = 0.0;
            dArray2[n + 1] = 0.0;
        }
        n3 = n;
        GMatrix.update_u(n3, gMatrix, dArray3, dArray5);
        GMatrix.update_v(n3, gMatrix2, dArray4, dArray6);
    }

    private static void print_se(double[] dArray, double[] dArray2) {
        System.out.println("\ns =" + dArray[0] + " " + dArray[1] + " " + dArray[2]);
        System.out.println("e =" + dArray2[0] + " " + dArray2[1]);
    }

    private static void update_v(int n, GMatrix gMatrix, double[] dArray, double[] dArray2) {
        int n2 = 0;
        while (n2 < gMatrix.nRow) {
            double d = gMatrix.values[n2][n];
            gMatrix.values[n2][n] = dArray[0] * d + dArray2[0] * gMatrix.values[n2][n + 1];
            gMatrix.values[n2][n + 1] = -dArray2[0] * d + dArray[0] * gMatrix.values[n2][n + 1];
            ++n2;
        }
    }

    private static void chase_up(double[] dArray, double[] dArray2, int n, GMatrix gMatrix) {
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        GMatrix gMatrix2 = new GMatrix(gMatrix.nRow, gMatrix.nCol);
        GMatrix gMatrix3 = new GMatrix(gMatrix.nRow, gMatrix.nCol);
        double d = dArray2[n];
        double d2 = dArray[n];
        int n2 = n;
        while (n2 > 0) {
            double d3 = GMatrix.compute_rot(d, d2, dArray4, dArray3);
            d = -dArray2[n2 - 1] * dArray4[0];
            d2 = dArray[n2 - 1];
            dArray[n2] = d3;
            dArray2[n2 - 1] = dArray2[n2 - 1] * dArray3[0];
            GMatrix.update_v_split(n2, n + 1, gMatrix, dArray3, dArray4, gMatrix2, gMatrix3);
            --n2;
        }
        dArray[n2 + 1] = GMatrix.compute_rot(d, d2, dArray4, dArray3);
        GMatrix.update_v_split(n2, n + 1, gMatrix, dArray3, dArray4, gMatrix2, gMatrix3);
    }

    private static void chase_across(double[] dArray, double[] dArray2, int n, GMatrix gMatrix) {
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        GMatrix gMatrix2 = new GMatrix(gMatrix.nRow, gMatrix.nCol);
        GMatrix gMatrix3 = new GMatrix(gMatrix.nRow, gMatrix.nCol);
        double d = dArray2[n];
        double d2 = dArray[n + 1];
        int n2 = n;
        while (n2 < gMatrix.nCol - 2) {
            double d3 = GMatrix.compute_rot(d2, d, dArray4, dArray3);
            d = -dArray2[n2 + 1] * dArray4[0];
            d2 = dArray[n2 + 2];
            dArray[n2 + 1] = d3;
            dArray2[n2 + 1] = dArray2[n2 + 1] * dArray3[0];
            GMatrix.update_u_split(n, n2 + 1, gMatrix, dArray3, dArray4, gMatrix2, gMatrix3);
            ++n2;
        }
        dArray[n2 + 1] = GMatrix.compute_rot(d2, d, dArray4, dArray3);
        GMatrix.update_u_split(n, n2 + 1, gMatrix, dArray3, dArray4, gMatrix2, gMatrix3);
    }

    private static void update_v_split(int n, int n2, GMatrix gMatrix, double[] dArray, double[] dArray2, GMatrix gMatrix2, GMatrix gMatrix3) {
        int n3 = 0;
        while (n3 < gMatrix.nRow) {
            double d = gMatrix.values[n3][n];
            gMatrix.values[n3][n] = dArray[0] * d - dArray2[0] * gMatrix.values[n3][n2];
            gMatrix.values[n3][n2] = dArray2[0] * d + dArray[0] * gMatrix.values[n3][n2];
            ++n3;
        }
        System.out.println("topr    =" + n);
        System.out.println("bottomr =" + n2);
        System.out.println("cosr =" + dArray[0]);
        System.out.println("sinr =" + dArray2[0]);
        System.out.println("\nm =");
        GMatrix.checkMatrix(gMatrix3);
        System.out.println("\nv =");
        GMatrix.checkMatrix(gMatrix2);
        gMatrix3.mul(gMatrix3, gMatrix2);
        System.out.println("\nt*m =");
        GMatrix.checkMatrix(gMatrix3);
    }

    private static void update_u_split(int n, int n2, GMatrix gMatrix, double[] dArray, double[] dArray2, GMatrix gMatrix2, GMatrix gMatrix3) {
        int n3 = 0;
        while (n3 < gMatrix.nCol) {
            double d = gMatrix.values[n][n3];
            gMatrix.values[n][n3] = dArray[0] * d - dArray2[0] * gMatrix.values[n2][n3];
            gMatrix.values[n2][n3] = dArray2[0] * d + dArray[0] * gMatrix.values[n2][n3];
            ++n3;
        }
        System.out.println("\nm=");
        GMatrix.checkMatrix(gMatrix3);
        System.out.println("\nu=");
        GMatrix.checkMatrix(gMatrix2);
        gMatrix3.mul(gMatrix2, gMatrix3);
        System.out.println("\nt*m=");
        GMatrix.checkMatrix(gMatrix3);
    }

    private static void update_u(int n, GMatrix gMatrix, double[] dArray, double[] dArray2) {
        int n2 = 0;
        while (n2 < gMatrix.nCol) {
            double d = gMatrix.values[n][n2];
            gMatrix.values[n][n2] = dArray[0] * d + dArray2[0] * gMatrix.values[n + 1][n2];
            gMatrix.values[n + 1][n2] = -dArray2[0] * d + dArray[0] * gMatrix.values[n + 1][n2];
            ++n2;
        }
    }

    private static void print_m(GMatrix gMatrix, GMatrix gMatrix2, GMatrix gMatrix3) {
        GMatrix gMatrix4 = new GMatrix(gMatrix.nCol, gMatrix.nRow);
        gMatrix4.mul(gMatrix2, gMatrix4);
        gMatrix4.mul(gMatrix4, gMatrix3);
        System.out.println("\n m = \n" + GMatrix.toString(gMatrix4));
    }

    private static String toString(GMatrix gMatrix) {
        StringBuffer stringBuffer = new StringBuffer(gMatrix.nRow * gMatrix.nCol * 8);
        int n = 0;
        while (n < gMatrix.nRow) {
            int n2 = 0;
            while (n2 < gMatrix.nCol) {
                if (Math.abs(gMatrix.values[n][n2]) < 1.0E-9) {
                    stringBuffer.append("0.0000 ");
                } else {
                    stringBuffer.append(gMatrix.values[n][n2]).append(" ");
                }
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    private static void print_svd(double[] dArray, double[] dArray2, GMatrix gMatrix, GMatrix gMatrix2) {
        GMatrix gMatrix3 = new GMatrix(gMatrix.nCol, gMatrix2.nRow);
        System.out.println(" \ns = ");
        int n = 0;
        while (n < dArray.length) {
            System.out.println(" " + dArray[n]);
            ++n;
        }
        System.out.println(" \ne = ");
        n = 0;
        while (n < dArray2.length) {
            System.out.println(" " + dArray2[n]);
            ++n;
        }
        System.out.println(" \nu  = \n" + gMatrix.toString());
        System.out.println(" \nv  = \n" + gMatrix2.toString());
        gMatrix3.setIdentity();
        n = 0;
        while (n < dArray.length) {
            gMatrix3.values[n][n] = dArray[n];
            ++n;
        }
        n = 0;
        while (n < dArray2.length) {
            gMatrix3.values[n][n + 1] = dArray2[n];
            ++n;
        }
        System.out.println(" \nm  = \n" + gMatrix3.toString());
        gMatrix3.mulTransposeLeft(gMatrix, gMatrix3);
        gMatrix3.mulTransposeRight(gMatrix3, gMatrix2);
        System.out.println(" \n u.transpose*m*v.transpose  = \n" + gMatrix3.toString());
    }

    static double max(double d, double d2) {
        if (d > d2) {
            return d;
        }
        return d2;
    }

    static double min(double d, double d2) {
        if (d < d2) {
            return d;
        }
        return d2;
    }

    static double compute_shift(double d, double d2, double d3) {
        double d4;
        double d5 = Math.abs(d);
        double d6 = Math.abs(d2);
        double d7 = Math.abs(d3);
        double d8 = GMatrix.min(d5, d7);
        double d9 = GMatrix.max(d5, d7);
        if (d8 == 0.0) {
            d4 = 0.0;
            if (d9 != 0.0) {
                double d10 = GMatrix.min(d9, d6) / GMatrix.max(d9, d6);
            }
        } else if (d6 < d9) {
            double d11 = d8 / d9 + 1.0;
            double d12 = (d9 - d8) / d9;
            double d13 = d6 / d9;
            double d14 = d13 * d13;
            double d15 = 2.0 / (Math.sqrt(d11 * d11 + d14) + Math.sqrt(d12 * d12 + d14));
            d4 = d8 * d15;
        } else {
            double d16 = d9 / d6;
            if (d16 == 0.0) {
                d4 = d8 * d9 / d6;
            } else {
                double d17 = d8 / d9 + 1.0;
                double d18 = (d9 - d8) / d9;
                double d19 = d17 * d16;
                double d20 = d18 * d16;
                double d21 = 1.0 / (Math.sqrt(d19 * d19 + 1.0) + Math.sqrt(d20 * d20 + 1.0));
                d4 = d8 * d21 * d16;
                d4 += d4;
            }
        }
        return d4;
    }

    static int compute_2X2(double d, double d2, double d3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n) {
        double d4;
        double d5;
        double d6 = 2.0;
        double d7 = 1.0;
        double d8 = dArray[0];
        double d9 = dArray[1];
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = d;
        double d16 = Math.abs(d15);
        double d17 = d3;
        double d18 = Math.abs(d3);
        int n2 = 1;
        boolean bl = d18 > d16;
        if (bl) {
            n2 = 3;
            double d19 = d15;
            d15 = d17;
            d17 = d19;
            d19 = d16;
            d16 = d18;
            d18 = d19;
        }
        if ((d5 = Math.abs(d4 = d2)) == 0.0) {
            dArray[1] = d18;
            dArray[0] = d16;
            d10 = 1.0;
            d11 = 1.0;
            d12 = 0.0;
            d13 = 0.0;
        } else {
            boolean bl2 = true;
            if (d5 > d16) {
                n2 = 2;
                if (d16 / d5 < 1.0E-10) {
                    bl2 = false;
                    d8 = d5;
                    d9 = d18 > 1.0 ? d16 / (d5 / d18) : d16 / d5 * d18;
                    d10 = 1.0;
                    d12 = d17 / d4;
                    d13 = 1.0;
                    d11 = d15 / d4;
                }
            }
            if (bl2) {
                double d20 = d16 - d18;
                double d21 = d20 == d16 ? 1.0 : d20 / d16;
                double d22 = d4 / d15;
                double d23 = 2.0 - d21;
                double d24 = d22 * d22;
                double d25 = d23 * d23;
                double d26 = Math.sqrt(d25 + d24);
                double d27 = d21 == 0.0 ? Math.abs(d22) : Math.sqrt(d21 * d21 + d24);
                double d28 = (d26 + d27) * 0.5;
                if (d5 > d16) {
                    n2 = 2;
                    if (d16 / d5 < 1.0E-10) {
                        bl2 = false;
                        d8 = d5;
                        d9 = d18 > 1.0 ? d16 / (d5 / d18) : d16 / d5 * d18;
                        d10 = 1.0;
                        d12 = d17 / d4;
                        d13 = 1.0;
                        d11 = d15 / d4;
                    }
                }
                if (bl2) {
                    d20 = d16 - d18;
                    d21 = d20 == d16 ? 1.0 : d20 / d16;
                    d22 = d4 / d15;
                    d23 = 2.0 - d21;
                    d24 = d22 * d22;
                    d25 = d23 * d23;
                    d26 = Math.sqrt(d25 + d24);
                    d27 = d21 == 0.0 ? Math.abs(d22) : Math.sqrt(d21 * d21 + d24);
                    d28 = (d26 + d27) * 0.5;
                    d9 = d18 / d28;
                    d8 = d16 * d28;
                    d23 = d24 == 0.0 ? (d21 == 0.0 ? GMatrix.d_sign(d6, d15) * GMatrix.d_sign(d7, d4) : d4 / GMatrix.d_sign(d20, d15) + d22 / d23) : (d22 / (d26 + d23) + d22 / (d27 + d21)) * (d28 + 1.0);
                    d21 = Math.sqrt(d23 * d23 + 4.0);
                    d11 = 2.0 / d21;
                    d13 = d23 / d21;
                    d10 = (d11 + d13 * d22) / d28;
                    d12 = d17 / d15 * d13 / d28;
                }
            }
            if (bl) {
                dArray3[0] = d13;
                dArray2[0] = d11;
                dArray5[0] = d12;
                dArray4[0] = d10;
            } else {
                dArray3[0] = d10;
                dArray2[0] = d12;
                dArray5[0] = d11;
                dArray4[0] = d13;
            }
            if (n2 == 1) {
                d14 = GMatrix.d_sign(d7, dArray5[0]) * GMatrix.d_sign(d7, dArray3[0]) * GMatrix.d_sign(d7, d);
            }
            if (n2 == 2) {
                d14 = GMatrix.d_sign(d7, dArray4[0]) * GMatrix.d_sign(d7, dArray3[0]) * GMatrix.d_sign(d7, d2);
            }
            if (n2 == 3) {
                d14 = GMatrix.d_sign(d7, dArray4[0]) * GMatrix.d_sign(d7, dArray2[0]) * GMatrix.d_sign(d7, d3);
            }
            dArray[n] = GMatrix.d_sign(d8, d14);
            double d29 = d14 * GMatrix.d_sign(d7, d) * GMatrix.d_sign(d7, d3);
            dArray[n + 1] = GMatrix.d_sign(d9, d29);
        }
        return 0;
    }

    static double compute_rot(double d, double d2, double[] dArray, double[] dArray2) {
        double d3;
        double d4;
        double d5;
        if (d2 == 0.0) {
            d5 = 1.0;
            d4 = 0.0;
            d3 = d;
        } else if (d == 0.0) {
            d5 = 0.0;
            d4 = 1.0;
            d3 = d2;
        } else {
            double d6 = d;
            double d7 = d2;
            double d8 = GMatrix.max(Math.abs(d6), Math.abs(d7));
            if (d8 >= 4.994797680505588E145) {
                int n = 0;
                while (d8 >= 4.994797680505588E145) {
                    ++n;
                    d8 = GMatrix.max(Math.abs(d6 *= 2.002083095183101E-146), Math.abs(d7 *= 2.002083095183101E-146));
                }
                d3 = Math.sqrt(d6 * d6 + d7 * d7);
                d5 = d6 / d3;
                d4 = d7 / d3;
                int n2 = n;
                int n3 = 1;
                while (n3 <= n) {
                    d3 *= 4.994797680505588E145;
                    ++n3;
                }
            } else if (d8 <= 2.002083095183101E-146) {
                int n = 0;
                while (d8 <= 2.002083095183101E-146) {
                    ++n;
                    d8 = GMatrix.max(Math.abs(d6 *= 4.994797680505588E145), Math.abs(d7 *= 4.994797680505588E145));
                }
                d3 = Math.sqrt(d6 * d6 + d7 * d7);
                d5 = d6 / d3;
                d4 = d7 / d3;
                int n4 = n;
                int n5 = 1;
                while (n5 <= n) {
                    d3 *= 2.002083095183101E-146;
                    ++n5;
                }
            } else {
                d3 = Math.sqrt(d6 * d6 + d7 * d7);
                d5 = d6 / d3;
                d4 = d7 / d3;
            }
            if (Math.abs(d) > Math.abs(d2) && d5 < 0.0) {
                d5 = -d5;
                d4 = -d4;
                d3 = -d3;
            }
        }
        dArray[0] = d4;
        dArray2[0] = d5;
        return d3;
    }

    static double d_sign(double d, double d2) {
        double d3 = d >= 0.0 ? d : -d;
        return d2 >= 0.0 ? d3 : -d3;
    }

    public Object clone() {
        GMatrix gMatrix = null;
        try {
            gMatrix = (GMatrix)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        gMatrix.values = new double[this.nRow][this.nCol];
        int n = 0;
        while (n < this.nRow) {
            int n2 = 0;
            while (n2 < this.nCol) {
                gMatrix.values[n][n2] = this.values[n][n2];
                ++n2;
            }
            ++n;
        }
        return gMatrix;
    }
}

