package de.ugoe.cs.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class FileTools {
	
	/**
	 * <p>
	 * Returns an array of the lines contained in a file. The line seperator is "\r\n".
	 * </p>
	 * @param filename name of the file
	 * @return string array, where each line contains a file
	 * @throws IOException see {@link FileReader#read(char[])}, {@link FileReader#close()} 
	 * @throws FileNotFoundException see {@link FileReader#FileReader(File)}
	 */
	public static String[] getLinesFromFile(String filename) throws IOException, FileNotFoundException {
		return getLinesFromFile(filename, true);
	}
	
	/**
	 * <p>
	 * Returns an array of the lines contained in a file.
	 * </p>
	 * @param filename name of the file
	 * @param cariageReturn if true, "\r\n", if false "\n" is used as line seperator
	 * @return string array, where each line contains a file
	 * @throws IOException see {@link FileReader#read(char[])}, {@link FileReader#close()} 
	 * @throws FileNotFoundException see {@link FileReader#FileReader(File)}
	 */
	public static String[] getLinesFromFile(String filename, boolean cariageReturn) throws IOException, FileNotFoundException {
		File f = new File(filename);
		FileReader reader = new FileReader(f);
		char[] buffer = new char[(int) f.length()];
		reader.read(buffer);
		reader.close();
		String splitString;
		if( cariageReturn ) {
			splitString = "\r\n";
		} else {
			splitString = "\n";
		}
		return (new String(buffer)).split(splitString);
	}

}
