package de.ugoe.cs.eventbench.commands;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDloadObject implements Command {

	@Override
	public void run(List<Object> parameters) {
		// TODO Auto-generated method stub
		String filename;
		String objectName;
		try {
			filename = (String) parameters.get(0);
			objectName = (String) parameters.get(1);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		Object data = null;
		FileInputStream fis = null;
		ObjectInputStream in = null;
		try {
			fis = new FileInputStream(filename);
			in = new ObjectInputStream(fis);
			data = in.readObject();
			in.close();
		} catch (IOException ex) {
			ex.printStackTrace();
		} catch (ClassNotFoundException ex) {
			ex.printStackTrace();
		}
		if( GlobalDataContainer.getInstance().addData(objectName, data ) ) {
			Console.traceln("Old data \"" + objectName + "\" overwritten");
		}
	}

	@Override
	public void help() {
		// TODO Auto-generated method stub
		Console.println("Usage: loadObject <filename> <objectName>");
	}

}
