package de.ugoe.cs.eventbench.models;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;

import de.ugoe.cs.eventbench.data.Event;

public class DeterministicFiniteAutomaton extends FirstOrderMarkovModel {

	/**
	 * Id for object serialization.
	 */
	private static final long serialVersionUID = 1L;

	public DeterministicFiniteAutomaton(Random r) {
		super(r);
	}

	@Override
	public double getProbability(List<Event<?>> context, Event<?> symbol) {
		double result = 0.0d;
		
		List<Event<?>> contextCopy;
		if( context.size()>=trieOrder ) {
			contextCopy = new LinkedList<Event<?>>(context.subList(context.size()-trieOrder+1, context.size()));
		} else {
			contextCopy = new LinkedList<Event<?>>(context);
		}

	
		List<Event<?>> followers = trie.getFollowingSymbols(contextCopy);
		
		if( followers.size()!=0 && followers.contains(symbol) ) {
			result = 1.0d / followers.size();
		}
		
		return result;
	}

}
