package de.ugoe.cs.eventbench.models;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

import de.ugoe.cs.eventbench.data.Event;

public interface IStochasticProcess extends Serializable {
	
	double getProbability(List<? extends Event<?>> context, Event<?> symbol);

	public List<? extends Event<?>> randomSequence();
	
	public Set<List<? extends Event<?>>> generateSequences(int length);
	
	public int getNumStates();
	
	public String[] getStateStrings();
	
	public Set<? extends Event<?>> getEvents();

}