package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.List;
import java.util.Set;

import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.models.IStochasticProcess;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDgenerateFixedLengthSequences implements Command {

	@Override
	public void run(List<Object> parameters) {
		String modelname;
		String sequencesName;
		int length;
		try {
			modelname = (String) parameters.get(0);
			sequencesName = (String) parameters.get(1);
			length = Integer.parseInt((String) parameters.get(2));
		}
		catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		IStochasticProcess model = null; 
		Object dataObject = GlobalDataContainer.getInstance().getData(modelname);
		if( dataObject==null ) {
			Console.println("Model " + modelname + " not found in storage.");
		}
		else if( !(dataObject instanceof IStochasticProcess) ) {
			Console.println("Object " + modelname + " not of type MarkovModel!");
		} else {
			model = (IStochasticProcess) dataObject;
			Set<List<? extends Event<?>>> sequences = model.generateValidSequences(length+2);
			if( GlobalDataContainer.getInstance().addData(sequencesName, sequences) ) {
				Console.traceln("Old data \"" + sequencesName + "\" overwritten");
			}
		}
	}

	@Override
	public void help() {
		Console.println("Usage: generateFixedLengthSequences <modelname> <sequencesName> <length>");
	}

}
